<?php

namespace Laravel\Vapor\Queue;

use Illuminate\Queue\SqsQueue;

class VaporQueue extends SqsQueue
{
    /**
     * Pop the next job off of the queue.
     *
     * @param  string  $queue
     * @return \Illuminate\Contracts\Queue\Job|null
     */
    public function pop($queue = null)
    {
        $response = $this->sqs->receiveMessage([
            'QueueUrl' => $queue = $this->getQueue($queue),
            'AttributeNames' => ['ApproximateReceiveCount'],
        ]);

        if (! is_null($response['Messages']) && count($response['Messages']) > 0) {
            return tap(new VaporJob(
                $this->container, $this->sqs, $response['Messages'][0],
                $this->connectionName, $queue
            ), function ($job) {
                $this->container
                     ->make(JobAttempts::class)
                     ->increment($job);
            });
        }
    }

    /**
     * Create a payload string from the given job and data.
     *
     * @param  string  $job
     * @param  string  $queue
     * @param  mixed  $data
     * @return array
     */
    protected function createPayloadArray($job, $queue, $data = '')
    {
        return array_merge(parent::createPayloadArray($job, $queue, $data), [
            'attempts' => 0,
        ]);
    }
}
