{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - school-management-software |  Online School Management 
@endsection

@section('content')
<!-- start -->
<div class="bg-red-600 py-8 lg:py-16 md:py-8">
	<div class="container mx-auto">
		<div class="text-center tracking-wider px-1">
		<h1 class="text-white font-plex text-2xl lg:text-4xl">School Management Software</h1>
		</div>
	</div>
</div>
<!-- end -->
<!-- <div class="bg-gray-400">
	<div class="container mx-auto py-16">
		<h1 class="text-3xl font-bold">School Management Software</h1>
	</div>
</div> -->
<div class="container mx-auto py-8 px-3">
<p class="leading-loose text-justify mb-8 text-gray-700">For schools to function properly nowadays there should be a proper level of communication between the administration and the parents. With concerns about their child’s education, parents wish to have the foremost information regarding school and classroom activities. Similarly a school administration also should comply with a lot of quality standards and report to the Board of Education. As a school admin, accessing the students’ data, teachers details, parent information, attendance, timetable, examination and even the library administration will all become a necessary data while handling management processes in a school.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">A school management software is an array of systemized data that are designed to manage the daily administrative operations of a school. Schools have a lot of issues in tracking attendance, managing database, collecting fees or having to take care of staff grievances. School management software helps the administrator to manage students by getting a class-wise report, parent report, and helps in timetable management, exam management, manage notice board, events, teachers, upcoming exams, record of students on leave, etc.</p>
<p class="leading-loose text-justify mb-8 text-gray-700">For example, when a school event is organized, it takes a toll on the organizers as they have to prepare for a lot of processes for the event. Using a school management software, will help you simplify the process. The event management module will help you to automatically send the notification to parents, update to teachers and students and describe the event in the calendar. </p>
<div class="flex flex-wrap">
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" width="512px" height="512px" class="h-8 fill-current"><g><g><g><path d="M466,242.581c0-168.832,0.472-158.076-1.102-161.96c3.369-8.323-1.27-17.612-9.777-20.043l-210-60    c-2.693-0.77-5.548-0.77-8.241,0l-210,60C20.439,62.417,16,68.303,16,75.001s4.439,12.583,10.879,14.423L106,112.029    c0,0.679,0,1.306,0,1.891c0,5.083,0,6.755,0,6.727c0,8.27,0,25.579,0,59.353c0,58.278,30.068,108.896,73.87,133.718l-8.275,16.55    c-40.483,2.316-78.308,19.564-107.364,49.156C33.129,411.1,16,452.855,16,497.001c0,8.284,6.716,15,15,15h420    c8.284,0,15-6.716,15-15c0-44.145-17.129-85.9-48.231-117.575c-29.054-29.59-66.879-46.827-107.359-49.146l-8.281-16.561    C345.932,288.897,376,238.279,376,180.001c0-3.699,0-66.967,0-67.971l60-17.143v147.694c-17.459,6.192-30,22.865-30,42.42v30    c0,8.284,6.716,15,15,15h60c8.284,0,15-6.716,15-15v-30C496,265.446,483.459,248.772,466,242.581z M226,482.001H46.804    c7.103-65.907,60.46-117.899,126.328-121.761L226,439.543V482.001z M198.309,343.923l9.286-18.573    c10.687,3.034,21.879,4.651,33.405,4.651s22.717-1.617,33.404-4.65l9.286,18.572L241,407.959L198.309,343.923z M308.868,360.241    c65.868,3.86,119.225,55.853,126.328,121.76H256v-42.458L308.868,360.241z M241,300.001c-50.888,0-93.431-41.589-102.988-96.587    c31.678,14.133,67.086,21.587,102.988,21.587c35.9,0,71.308-7.453,102.987-21.584C334.43,258.413,291.887,300.001,241,300.001z     M345.672,163.069c-0.872,4.334-3.441,7.986-7.037,9.752c-29.533,14.51-63.294,22.179-97.635,22.179    c-34.344,0-68.106-7.671-97.637-22.183c-4.892-2.403-7.363-7.967-7.363-13.031V120.6c108.861,31.103,101.999,29.4,105,29.4    c3,0-3.883,1.71,105-29.4C346,163.657,346.119,160.868,345.672,163.069z M241,119.401l-155.399-44.4L241,30.6l155.399,44.4    L241,119.401z M466,300.001h-30v-15c0-8.271,6.729-15,15-15s15,6.729,15,15V300.001z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M361,420.001h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S369.284,420.001,361,420.001z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Student management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The student management system manages students and gives reports based on their class, name, register number and/or their grades. The admin will be able to export and import the student database to Cloud storage and also add new students to the database. The student will have the option to view course details, upcoming events, exams, class timetable and submit assignments.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 -32 512 512" width="512px" class="h-8 fill-current"><g><path d="m464.867188 0h-224.933594c-25.988282 0-47.132813 21.144531-47.132813 47.132812v144.292969l-41.765625-20.769531c-1.410156-.703125-2.84375-1.367188-4.289062-1.996094 12.261718-12.800781 19.820312-30.144531 19.820312-49.226562 0-39.277344-31.953125-71.234375-71.230468-71.234375-39.28125 0-71.234376 31.957031-71.234376 71.234375 0 21.34375 9.449219 40.515625 24.371094 53.582031-27.480468 15.460937-48.472656 45.621094-48.472656 82.984375v48.199219c0 20.75 13.472656 38.410156 32.132812 44.6875v83.847656c0 8.28125 6.714844 15 15 15h96.398438c8.285156 0 15-6.71875 15-15v-168.535156l48.023438 24.007812c18.378906 9.1875 43.308593 3.710938 54.582031-17.207031h53.78125l-56.949219 156.605469c-2.832031 7.785156 1.1875 16.394531 8.972656 19.222656 8.898438 3.238281 16.8125-2.34375 19.222656-8.96875l60.675782-166.859375h10.515625l61.296875 166.90625c2.328125 6.332031 10.183594 12.238281 19.253906 8.90625 7.773438-2.855469 11.765625-11.472656 8.90625-19.25l-57.5-156.5625h75.554688c25.484374 0 47.132812-20.558594 47.132812-47.132812v-176.734376c0-26.578124-21.648438-47.132812-47.132812-47.132812zm-410.765626 119.433594c0-22.738282 18.496094-41.234375 41.230469-41.234375 22.738281 0 41.234375 18.496093 41.234375 41.234375 0 22.734375-18.496094 41.230468-41.234375 41.230468-22.734375 0-41.230469-18.496093-41.230469-41.230468zm181.398438 135.527344c-.039062.109374-.078125.222656-.113281.335937-1.023438 2.855469-3.335938 5.261719-6.167969 6.425781-2.996094 1.21875-6.367188 1.089844-9.246094-.347656-28.523437-14.269531-69.738281-34.859375-69.738281-34.859375-9.953125-4.976563-21.703125 2.273437-21.703125 13.417969v177.800781h-66.398438v-81.402344c0-8.28125-6.71875-15-15-15-9.449218 0-17.132812-7.683593-17.132812-17.132812v-48.199219c0-36.652344 29.84375-65.332031 65.332031-65.332031h13.253907c10.054687 0 20.097656 2.359375 29.070312 6.839843 0 0 74.402344 37 93.351562 46.4375 4.058594 2.015626 5.988282 6.75 4.492188 11.015626zm246.5-31.09375c0 4.582031-1.777344 8.882812-5.011719 12.117187-3.183593 3.1875-7.601562 5.015625-12.121093 5.015625h-200.46875c-.027344-.082031-.046876-.164062-.074219-.242188l37.226562-74.449218c3.703125-7.410156.703125-16.417969-6.707031-20.125-7.40625-3.703125-16.417969-.703125-20.125 6.707031l-31.75 63.496094c-5.917969-2.949219-12.796875-6.375-20.167969-10.039063v-159.214844c0-9.445312 7.683594-17.132812 17.132813-17.132812h224.933594c4.519531 0 8.9375 1.828125 12.125 5.023438 3.230468 3.226562 5.007812 7.527343 5.007812 12.109374zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m432.734375 64.265625h-160.667969c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m432.734375 120.5h-80.335937c-8.28125 0-15 6.714844-15 15s6.71875 15 15 15h80.335937c8.28125 0 15-6.714844 15-15s-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m432.734375 176.734375h-80.335937c-8.28125 0-15 6.714844-15 15 0 8.28125 6.71875 15 15 15h80.335937c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Teacher management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The teacher management module lets teachers send exam results, child disciplinary report and homework to parents. Details of each teacher and their info will be updated here. The admin can add new teachers or remove retired teacher’s details from the module.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" class="h-8 fill-current"><g><g><path d="M71.069,354.63c-1.859-1.86-4.439-2.92-7.069-2.92s-5.21,1.06-7.07,2.92c-1.86,1.86-2.93,4.439-2.93,7.08 c0,2.63,1.069,5.2,2.93,7.06c1.86,1.87,4.44,2.94,7.07,2.94s5.21-1.07,7.069-2.94c1.861-1.86,2.931-4.44,2.931-7.06 C74,359.08,72.93,356.5,71.069,354.63z"></path></g></g><g><g><path d="M484.095,282.754l-0.716-0.743c-3.845-3.965-10.177-4.063-14.141-0.217c-3.965,3.845-4.062,10.176-0.217,14.141 l0.594,0.616c1.966,2.063,4.602,3.102,7.242,3.102c2.478,0,4.96-0.916,6.896-2.76 C487.751,293.083,487.904,286.753,484.095,282.754z"></path></g></g><g><g><path d="M505.89,317.818c-1.895-5.188-7.635-7.857-12.823-5.964c-5.188,1.895-7.858,7.636-5.964,12.823 c3.25,8.899,4.897,18.265,4.897,27.835V465h-34V361.705c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465h-79.464v-77.749 c0-33.581-22.735-62.688-55.289-70.781c-0.137-0.034-0.273-0.065-0.411-0.094l-0.786-0.161 c8.261-8.487,14.198-19.236,16.772-31.222l34.632,55.38c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699 l43.097-68.946c8.763,0.281,17.332,1.934,25.502,4.957c1.145,0.423,2.316,0.624,3.469,0.624c4.065,0,7.887-2.498,9.38-6.533 c1.916-5.181-0.729-10.933-5.909-12.849c-9.599-3.551-19.628-5.592-29.877-6.112c18.239-15.421,29.85-38.448,29.85-64.146v-31.431 v-17.814V133c0-0.933-0.137-1.832-0.376-2.688c-3.955-42.668-39.941-76.189-83.624-76.189h-0.001 c-43.683,0-79.668,33.521-83.623,76.189c-0.239,0.856-0.376,1.755-0.376,2.688v5.123v17.814v31.431 c0,4.391,0.342,8.702,0.994,12.913c-5.805-2.224-12.01-3.625-18.478-4.069v-58.468C260.44,76.679,210.762,27,149.697,27 S38.953,76.679,38.953,137.744v135.059C15.259,291.331,0,320.172,0,352.513V475c0,5.522,4.478,10,10,10h492 c5.522,0,10-4.478,10-10V352.513C512,340.595,509.944,328.922,505.89,317.818z M361.931,316.208l-32.013-51.191 c9.871,4.084,20.677,6.351,32.006,6.351h28.036L361.931,316.208z M297.925,138.123c-0.001-35.29,28.709-64,63.999-64 c35.29,0,64,28.71,64,64v0.341l-34.438-20.232c-4.211-2.475-9.593-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506 h-26.181V138.123z M297.924,165.937h26.181c24.218,0,47.177-9.521,64.2-26.378l37.619,22.101v25.708c0,35.29-28.711,64-64.001,64 c-35.289,0-63.999-28.71-63.999-64V165.937z M150.076,251.368c-35.29,0-64-28.71-64-64v-21.431h26.182 c24.218,0,47.177-9.521,64.2-26.378l37.618,22.101v25.708C214.076,222.658,185.366,251.368,150.076,251.368z M181.578,265.216 l-31.874,50.992l-28.041-44.84h28.413C161.215,271.368,171.843,269.17,181.578,265.216z M211.742,261.333H243.6 c6.688,0,13.166-1.783,18.829-4.999l17.178,4.652c0.853,0.231,1.731,0.349,2.614,0.349h18.037v10.19 c0,24.356-19.854,44.172-44.258,44.172s-44.258-19.815-44.258-44.172V261.333z M295.98,241.334h-12.429l-5.961-1.614 c0.94-4.127-0.824-8.56-4.663-10.828c-4.755-2.809-10.886-1.232-13.696,3.522c-3.251,5.502-9.24,8.92-15.631,8.92h-27.58 c7.116-14.941,22.359-25.293,39.98-25.293C273.621,216.041,288.864,226.394,295.98,241.334z M58.953,137.744 C58.953,87.708,99.661,47,149.697,47s90.743,40.708,90.743,90.744v60.212c-2.515,0.628-4.969,1.409-7.358,2.325 c0.652-4.21,0.994-8.522,0.994-12.913v-31.431c0-3.497-1.92-6.851-4.935-8.622l-49.503-29.083 c-4.211-2.474-9.592-1.544-12.73,2.199c-13.583,16.209-33.502,25.506-54.65,25.506H76.076c-5.522,0-10,4.477-10,10v31.431 c0,25.692,11.606,48.714,29.837,64.135c-13.133,0.672-25.609,3.866-36.96,9.098V137.744z M153.464,465H74v-59.333 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10V465H20V352.513c0-43.73,34.776-79.471,78.123-81.068l43.104,68.928 c1.828,2.923,5.032,4.698,8.479,4.698c3.447,0,6.651-1.776,8.479-4.699l34.891-55.818c2.522,12.161,8.509,23.064,16.868,31.655 l-0.86,0.183c-0.111,0.024-0.222,0.05-0.331,0.077c-32.554,8.094-55.289,37.2-55.289,70.781V465z M338.536,465h-29.229v-62 c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-76v-62c0-5.522-4.478-10-10-10c-5.522,0-10,4.478-10,10v62h-19.844v-77.749 c0-24.319,16.423-45.404,39.957-51.333l20.106-4.281c6.999,2.618,14.57,4.059,22.473,4.059c7.793,0,15.266-1.395,22.183-3.945 l20.433,4.176c23.517,5.94,39.921,27.016,39.921,51.324V465z"></path></g></g><g><g><path d="M337.16,175.83c-1.86-1.86-4.44-2.93-7.07-2.93c-2.64,0-5.21,1.07-7.07,2.93c-1.87,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.06,5.21,2.93,7.07c1.86,1.87,4.431,2.93,7.07,2.93c2.63,0,5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.43,2.93-7.07 C340.09,180.27,339.02,177.69,337.16,175.83z"></path></g></g><g><g><path d="M400.83,175.83c-1.86-1.86-4.44-2.93-7.07-2.93s-5.21,1.07-7.07,2.93c-1.859,1.86-2.93,4.44-2.93,7.07 c0,2.64,1.07,5.21,2.93,7.07c1.86,1.87,4.44,2.93,7.07,2.93s5.21-1.06,7.07-2.93c1.859-1.86,2.93-4.44,2.93-7.07 S402.69,177.69,400.83,175.83z"></path></g></g><g><g><path d="M380.686,207.885c-3.906-3.905-10.236-3.905-14.142,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.214,5.213,12.063,7.82,18.911,7.82s13.697-2.607,18.911-7.82 C384.591,218.123,384.591,211.791,380.686,207.885z"></path></g></g><g><g><path d="M125.309,175.83c-1.859-1.86-4.439-2.93-7.069-2.93c-2.631,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.86,1.87,4.439,2.93,7.07,2.93c2.63,0,5.21-1.06,7.069-2.93c1.86-1.86,2.931-4.44,2.931-7.07 S127.17,177.69,125.309,175.83z"></path></g></g><g><g><path d="M188.979,175.83c-1.859-1.86-4.43-2.93-7.069-2.93c-2.63,0-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07 s1.069,5.21,2.93,7.07c1.861,1.86,4.44,2.93,7.07,2.93c2.64,0,5.21-1.07,7.069-2.93c1.87-1.86,2.931-4.44,2.931-7.07 S190.849,177.69,188.979,175.83z"></path></g></g><g><g><path d="M168.84,207.885c-3.906-3.905-10.236-3.905-14.143,0c-2.629,2.63-6.908,2.63-9.537,0c-3.906-3.905-10.236-3.905-14.143,0 c-3.905,3.906-3.905,10.238,0.001,14.143c5.214,5.213,12.063,7.82,18.911,7.82c6.848,0,13.697-2.607,18.911-7.82 C172.745,218.123,172.745,211.791,168.84,207.885z"></path></g></g><g><g><path d="M274.911,282.7c-3.906-3.904-10.236-3.904-14.143,0c-2.629,2.631-6.908,2.631-9.537,0c-3.906-3.904-10.236-3.904-14.143,0 c-3.905,3.905-3.905,10.237,0,14.143c5.215,5.214,12.063,7.82,18.912,7.82s13.697-2.606,18.911-7.82 C278.816,292.938,278.816,286.606,274.911,282.7z"></path></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Parent management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Parents can view their child’s academic progress, get notified of upcoming school events, fee payment, disciplinary record, child’s attendance, etc. Through the parent management system, admin can send any message regarding the student or urgent information to the parent and vice versa. The parents will also be able to send feedback to the administration regarding any issue with their child’s education.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 511.998 511.998" xml:space="preserve" width="512px" height="512px" class="h-8 fill-current"><g><g><g><path d="M386.872,397.626c-2.031-5.158-7.859-7.698-13.02-5.663l-70.492,27.755c-5.159,2.031-7.695,7.86-5.663,13.02    c1.556,3.951,5.339,6.364,9.344,6.364c1.223,0,2.468-0.226,3.675-0.701l70.492-27.755    C386.368,408.615,388.904,402.786,386.872,397.626z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M402.433,381.438c-12.919,0-12.94,20.078,0,20.078C415.352,401.516,415.374,381.438,402.433,381.438z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M478.201,247.628c-0.138-0.66-0.34-1.295-0.6-1.9c0,0-0.001-0.002-0.001-0.003c-0.006-0.013-0.013-0.025-0.019-0.039    c-0.125-0.289-0.263-0.57-0.415-0.844c-0.064-0.117-0.139-0.228-0.208-0.341c-0.097-0.162-0.192-0.324-0.298-0.48    c-0.109-0.161-0.23-0.312-0.347-0.465c-0.077-0.099-0.151-0.203-0.232-0.3c-0.138-0.165-0.284-0.319-0.431-0.474    c-0.075-0.079-0.147-0.161-0.225-0.238c-0.149-0.147-0.304-0.282-0.46-0.419c-0.089-0.078-0.177-0.159-0.269-0.234    c-0.146-0.117-0.296-0.226-0.448-0.334c-0.115-0.083-0.229-0.17-0.347-0.248c-0.133-0.088-0.272-0.168-0.409-0.249    c-0.146-0.086-0.29-0.175-0.44-0.254c-0.12-0.063-0.246-0.118-0.368-0.178c-0.171-0.081-0.341-0.164-0.518-0.236    c-0.12-0.049-0.244-0.089-0.365-0.134c-0.181-0.065-0.36-0.133-0.546-0.189c-0.147-0.044-0.296-0.077-0.445-0.114    c-0.162-0.04-0.321-0.084-0.486-0.117c-0.221-0.044-0.444-0.073-0.668-0.102c-0.095-0.012-0.19-0.031-0.286-0.04    c-1.046-0.105-2.117-0.043-3.177,0.195c-0.616,0.137-1.213,0.326-1.781,0.571l-54.72,23.5    c-23.478-40.073-61.031-68.797-104.573-81.214c29.199-16.986,48.872-48.62,48.872-84.765C353.991,43.955,310.031,0,255.999,0    c-54.028,0-97.982,43.954-97.982,97.982c0,36.145,19.672,67.778,48.868,84.765c-43.537,12.416-81.091,41.139-104.576,81.212    l-54.722-23.498c-0.618-0.266-1.268-0.475-1.943-0.612c-0.673-0.139-1.35-0.204-2.021-0.204c-0.002,0-0.004,0-0.005,0    c-0.329,0-0.656,0.017-0.981,0.049c-0.122,0.012-0.241,0.035-0.362,0.051c-0.199,0.027-0.397,0.052-0.592,0.09    c-0.182,0.035-0.357,0.083-0.535,0.128c-0.133,0.034-0.266,0.063-0.397,0.102c-0.197,0.058-0.388,0.13-0.579,0.2    c-0.111,0.041-0.224,0.077-0.334,0.122c-0.184,0.075-0.361,0.161-0.54,0.246c-0.116,0.055-0.234,0.107-0.348,0.168    c-0.156,0.082-0.305,0.173-0.455,0.262c-0.133,0.079-0.266,0.156-0.396,0.24c-0.122,0.08-0.238,0.168-0.356,0.254    c-0.149,0.107-0.297,0.214-0.441,0.329c-0.093,0.076-0.182,0.158-0.272,0.237c-0.156,0.135-0.31,0.27-0.458,0.416    c-0.078,0.077-0.151,0.16-0.226,0.24c-0.147,0.155-0.292,0.308-0.43,0.472c-0.081,0.097-0.155,0.2-0.232,0.3    c-0.118,0.154-0.238,0.304-0.348,0.465c-0.106,0.155-0.201,0.318-0.298,0.479c-0.069,0.115-0.143,0.224-0.208,0.342    c-0.152,0.274-0.288,0.555-0.415,0.844c-0.006,0.013-0.013,0.025-0.019,0.039c0,0.001-0.001,0.002-0.001,0.002    c-0.26,0.606-0.463,1.242-0.6,1.901c-0.144,0.685-0.213,1.373-0.213,2.057V410.75c0,4.014,2.39,7.641,6.078,9.224l212.378,91.206    c0.348,0.15,0.702,0.274,1.056,0.383c0.059,0.018,0.12,0.029,0.179,0.046c0.377,0.107,0.756,0.189,1.136,0.25    c0.09,0.014,0.181,0.029,0.271,0.041c0.439,0.058,0.877,0.098,1.315,0.098c0.039,0,0.077-0.008,0.117-0.009    c0.385-0.004,0.77-0.035,1.153-0.084c0.128-0.016,0.254-0.036,0.38-0.058c0.344-0.057,0.686-0.132,1.024-0.226    c0.078-0.022,0.158-0.037,0.236-0.061c0.356-0.107,0.709-0.232,1.055-0.38l212.378-91.206c3.687-1.583,6.078-5.21,6.078-9.224    V249.685C478.415,249.001,478.346,248.313,478.201,247.628z M178.093,97.983c0-42.956,34.947-77.904,77.904-77.904    c42.962,0,77.914,34.948,77.914,77.904c0,42.963-34.951,77.914-77.914,77.914C213.04,175.897,178.093,140.946,178.093,97.983z     M245.957,486.722l-192.3-82.583V264.92h0.001l48.648,20.89c0.134,0.064,0.27,0.126,0.407,0.186l143.245,61.51V486.722z     M255.996,329.964l-135.104-58.013c28.622-47.125,79.447-75.975,135.105-75.975c55.666,0,106.49,28.848,135.103,75.969    L255.996,329.964z M458.336,404.138l-192.3,82.583V347.504l192.3-82.583V404.138z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Class management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The admin can manage all the classes through the class management system. He/she can generate records of the classes based on the teacher handling, standard and section. It also allows the admin to allot seat to the students in the class, assign teachers, etc.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px" class="h-8 fill-current"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Timetable management system</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Through the timetable management system, one can get an overview of all the classes’ timetable. The faculty members can also view their individual timetable and manage their schedules accordingly. This helps the admin manage and plan each individual class and teacher timetable accordingly.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2  lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" width="512px" height="512px" class="h-8 fill-current"><g><g><g><path d="M347,61h-46V45c0-8.284-6.716-15-15-15h-47.57C232.239,12.539,215.556,0,196,0c-19.556,0-36.239,12.539-42.43,30H105    c-8.284,0-15,6.716-15,15v16H45C20.187,61,0,81.187,0,106v361c0,24.813,20.187,45,45,45h302c24.813,0,45-20.187,45-45V106    C392,81.187,371.813,61,347,61z M120,60h46c8.284,0,15-6.716,15-15c0-8.271,6.729-15,15-15s15,6.729,15,15c0,8.284,6.716,15,15,15    h45v16c0,8.271-6.729,15-15,15H135c-8.271,0-15-6.729-15-15V60z M362,467c0,8.271-6.729,15-15,15H45c-8.271,0-15-6.729-15-15V106    c0-8.271,6.729-15,15-15h47.58c6.192,17.459,22.865,30,42.42,30h121c19.555,0,36.228-12.541,42.42-30H347c8.271,0,15,6.729,15,15    V467z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M176.693,260.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,344.534,101.16,346,105,346    c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,275.885,182.502,266.388,176.693,260.482z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M176.693,365.482c-5.808-5.906-15.306-5.985-21.212-0.175l-50.394,49.568l-19.481-19.481    c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213l30.001,30C97.321,449.534,101.16,451,105,451    c3.798,0,7.599-1.434,10.518-4.306l61-60C182.424,380.885,182.502,371.388,176.693,365.482z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M145.607,215.394L126.213,196l19.393-19.393c5.858-5.858,5.858-15.355,0-21.213c-5.857-5.858-15.355-5.858-21.213,0    L105,174.787l-19.394-19.393c-5.857-5.858-15.355-5.858-21.213,0c-5.858,5.858-5.858,15.355,0,21.213L83.787,196l-19.393,19.393    c-5.858,5.858-5.858,15.356,0,21.214c5.857,5.857,15.355,5.858,21.213,0L105,217.213l19.394,19.394    c5.857,5.857,15.355,5.858,21.213,0C151.465,230.749,151.465,221.252,145.607,215.394z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M317,181h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,181,317,181z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M317,286h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,286,317,286z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M317,391h-91c-8.284,0-15,6.716-15,15s6.716,15,15,15h91c8.284,0,15-6.716,15-15S325.284,391,317,391z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g><g><g><path d="M467,91c-24.813,0-45,20.187-45,45c0,9.542,0,230.112,0,240c0,1.614,0.289,3.286,0.754,4.697l30,91    C454.781,477.845,460.525,482,467,482c6.475,0,12.219-4.155,14.246-10.303l30-91C511.75,379.165,512,377.465,512,376    c0-9.872,0-230.419,0-240C512,111.187,491.813,91,467,91z M467,419.091l-12.388-37.576c3.792-1.924,8.012-2.942,12.388-2.942    c4.376,0,8.596,1.018,12.388,2.942L467,419.091z M482,350.558c-4.832-1.299-9.862-1.985-15-1.985s-10.168,0.685-15,1.984V211h30    V350.558z M482,181h-30v-45c0-8.271,6.729-15,15-15s15,6.729,15,15V181z" data-original="#000000" data-old_color="#000000" fill="" class="active-path"></path></g></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Exam schedule and management</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">The admin can update the examination schedule for every class on the exam schedule and management system. Through this, the class, date of the exam and subject will be uploaded which will be viewed by teachers, students and parents. The admin can add new exams to the system. This in turn will be viewed by the teachers, students and parents who will be notified once the timetable is updated. The admin will be able to process the results, generate report card and have an automated grading system once he/she enters the mark input.</p>
</div>
</div>
</div>
<!-- **** -->
</div>





<p class="leading-loose text-justify mb-8 text-gray-700">Gego K12 is a school management software that has been specifically designed and developed to meet all the requirements of different school systems.</p>

</div>
@endsection 