{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - Facilities Management Software for Schools
@endsection

@section('content')
<!-- start -->
<div class="bg-red-600 py-8 lg:py-16 md:py-8">
	<div class="container mx-auto">
		<div class="text-center tracking-wider px-1">
		<h1 class="text-white font-plex text-2xl lg:text-4xl">Facilities Management Software for Schools</h1>
		</div>
	</div>
</div>
<!-- end -->
<!-- <div class="bg-gray-400">
	<div class="container mx-auto py-16">
		<h1 class="text-4xl font-bold">Facilities Management Software for Schools</h1>
	</div>
</div> -->
<div class="container mx-auto py-16 px-3">
<div class="flex flex-col lg:flex-row items-center justify-between lg:mb-8">
<div class="w-full lg:w-2/3">
<p class="leading-loose text-justify  text-gray-700">Facilities management is an important part of the overall management of a school. To get a full return on investment from a school, maximum utilization and right management of the facilities is a must. With the advancements made in technology and science, the school admin will likely have a successful facilities management when using modern tools. The physical environment in every school determines if the school meets its objective or not. Any school which envisions providing a quality education to students should provide the necessary school facilities, resources and the right services to them. Students and parents have a high expectation of the education system and the school premises as well. For example, the students require a place to study, conduct experiments, train for sports and other activities while the teachers need a place for office, classrooms and meeting halls.</p>
</div>
<div class="w-full lg:w-1/3">
	<img src="{{url('images/classroom.jpg')}}" class="mx-auto">
</div>
</div>
<p class="leading-loose text-justify mb-8 text-gray-700">In such ways, tools, equipments and supplies are important for educational use and serves various purposes which lets students learn by providing computers in computer labs, tubes, microscopes for chemical experiments in laboratories and also sports equipments. The teachers and students use the cafeteria, restrooms, offices, laboratories, classrooms, workshops, etc. providing a complete furniture system in the school is important because it tends to encourage flexibility and creativity for the students and staff. Mostly school managements tend to repair or service a facility only when there is a major catastrophe in the system. Schools should respond to situations by having a regular check up on the facilities. For instance, without proper maintenance in places, hazardous material spills can occur which can serve as a cause for a safety concern among parents and students.</p>

<div class="flex flex-wrap">
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg class="h-8 fill-current" id="Solid" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m56 368h16v112h-16z"/><path d="m32 336h72v16h-72z"/><path d="m248 336h24v16h-24z"/><path d="m376 464h-80a8.009 8.009 0 0 0 -8 8v8h112v-8a8.009 8.009 0 0 0 -8-8z"/><path d="m136 400h16v48h-16z"/><path d="m304 400h16v48h-16z"/><path d="m208 464h-80a8.009 8.009 0 0 0 -8 8v8h112v-8a8.009 8.009 0 0 0 -8-8z"/><path d="m120 384h112v-56h-112zm48-40h16a8 8 0 0 1 0 16h-16a8 8 0 0 1 0-16z"/><path d="m80 56a8 8 0 0 1 8-8h336a8 8 0 0 1 8 8v184h16v-200a8.009 8.009 0 0 0 -8-8h-368a8.009 8.009 0 0 0 -8 8v200h16z"/><path d="m128 240h64v32h-64z"/><path d="m208 240h208v-176h-320v176h16v-8a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8z"/><path d="m448 368h16v112h-16z"/><path d="m208 272h232a8.009 8.009 0 0 0 8-8v-8h-240z"/><path d="m416 336h64v16h-64z"/><path d="m112 272v-16h-48v8a8.009 8.009 0 0 0 8 8z"/><path d="m288 384h112v-56h-112zm48-40h16a8 8 0 0 1 0 16h-16a8 8 0 0 1 0-16z"/><path d="m200 400h16v48h-16z"/><path d="m368 400h16v48h-16z"/></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Classroom facilities management</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Managing the classroom facilities like fan, chairs, tables which account for a majority of the school facilities. These should be properly managed and checked if the chairs have a loose leg or the fan is not working. Regular maintenance of these facilities will ensure in a smooth flow of the management.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="96.903px" height="96.904px" viewBox="0 0 96.903 96.904" xml:space="preserve" class="h-8 fill-current"><g><path d="M96.123,52.261l-22.984-8.418v-25.62c0-0.494-0.313-0.934-0.781-1.096L48.826,8.508c-0.244-0.086-0.518-0.084-0.762,0
    l-23.488,8.381c-0.237,0.084-0.441,0.238-0.542,0.398c-0.172,0.207-0.267,0.471-0.267,0.738v25.807l-22.958,8.19
    c-0.237,0.085-0.441,0.239-0.542,0.399C0.095,52.628,0,52.892,0,53.16v26.043c0,0.49,0.313,0.932,0.778,1.094l23.502,8.1
    c0.245,0.084,0.518,0.084,0.763,0l23.409-8.062l23.36,8.062c0.244,0.084,0.518,0.084,0.763,0l23.508-8.11
    c0.489-0.15,0.82-0.596,0.82-1.109V53.357C96.903,52.863,96.592,52.423,96.123,52.261z M69.042,42.082l-18.063,6.113V28.822
    l18.063-6.625V42.082z M48.444,12.712l16.801,6.277l-16.781,6.215l-17.73-6.119L48.444,12.712z M24.698,60.339L6.968,54.22
    l17.711-6.373l16.801,6.277L24.698,60.339z M45.276,77.216L27.212,83.33V63.957l18.064-6.625V77.216z M72.229,60.339L54.499,54.22
    l17.711-6.373l16.802,6.277L72.229,60.339z M92.807,77.216L74.743,83.33V63.957l18.063-6.625V77.216z"></path></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Products</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Every product in the school accounts as a facility. For example, an RO water tank in the school which is a facility for the staff and students should be regularly monitored. Every facility should be regularly serviced and updated on when the last service was and when next the product should be serviced.</p>
</div>
</div>
</div>
<!-- **** -->
<!-- **** -->
<div class="w-full lg:w-1/2 lg:px-5 py-2">
<div class="px-4 py-3 flex">
<div>
	<div class="bg-red-300 text-red-700 w-16 p-4 rounded-full flex items-center justify-center">
		<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" class="h-8 fill-current"><g><g><path d="M256,0C148.773,0,61.538,87.235,61.538,194.462c0,57.897,36.036,139.279,69.759,196.134
      C152.949,427.099,208.441,512,256,512s103.051-84.901,124.703-121.404c33.723-56.856,69.759-138.237,69.759-196.134
      C450.462,87.235,363.227,0,256,0z M355.297,375.527c-41.64,70.202-81.472,106.934-99.298,106.934s-57.657-36.732-99.297-106.934
      c-39.866-67.212-65.626-138.284-65.626-181.066c0-90.938,73.985-164.923,164.923-164.923s164.923,73.985,164.923,164.923
      C420.923,237.243,395.164,308.316,355.297,375.527z"></path></g></g> <g><g><path d="M358.816,183.019l-19.692-68.923c-1.812-6.341-7.607-10.712-14.201-10.712H187.077c-6.594,0-12.389,4.371-14.201,10.712
      l-19.692,68.923c-0.377,1.32-0.568,2.685-0.568,4.058c0,19.254,12.348,35.671,29.539,41.767v66.54
      c0,8.156,6.613,14.769,14.769,14.769h118.154c8.157,0,14.769-6.613,14.769-14.769v-66.54c17.19-6.097,29.539-22.513,29.539-41.767
      C359.385,185.704,359.194,184.34,358.816,183.019z M300.308,280.615h-88.615v-51.772c0.678-0.24,1.349-0.498,2.012-0.77
      c0.012-0.005,0.025-0.01,0.036-0.015c0.638-0.263,1.269-0.541,1.891-0.832c0.048-0.023,0.096-0.045,0.145-0.069
      c0.58-0.274,1.152-0.559,1.718-0.858c0.086-0.045,0.171-0.09,0.256-0.135c0.517-0.277,1.027-0.563,1.532-0.86
      c0.126-0.074,0.253-0.147,0.379-0.223c0.449-0.27,0.891-0.548,1.329-0.833c0.169-0.11,0.341-0.218,0.508-0.33
      c0.371-0.248,0.735-0.506,1.099-0.765c0.223-0.159,0.447-0.314,0.667-0.477c0.265-0.197,0.524-0.402,0.784-0.605
      c0.303-0.235,0.608-0.467,0.906-0.709c0.022-0.018,0.043-0.037,0.065-0.055c0.487-0.4,0.97-0.805,1.44-1.226
      c1.211,1.083,2.487,2.089,3.808,3.032c0.304,0.218,0.607,0.44,0.917,0.65c0.005,0.003,0.009,0.006,0.014,0.009
      c6.543,4.436,14.328,7.17,22.716,7.561c0.692,0.033,1.386,0.049,2.084,0.049c0.698,0,1.392-0.017,2.084-0.049
      c8.388-0.39,16.173-3.125,22.716-7.561c0.005-0.003,0.009-0.006,0.014-0.009c0.31-0.211,0.611-0.432,0.917-0.65
      c1.32-0.943,2.596-1.95,3.809-3.032c0.471,0.42,0.953,0.826,1.44,1.226c0.022,0.019,0.043,0.037,0.065,0.055
      c0.296,0.242,0.602,0.474,0.904,0.708c0.262,0.203,0.521,0.409,0.787,0.607c0.219,0.161,0.443,0.316,0.665,0.475
      c0.364,0.26,0.729,0.518,1.101,0.767c0.168,0.112,0.339,0.22,0.508,0.33c0.438,0.285,0.881,0.564,1.329,0.833
      c0.126,0.075,0.252,0.149,0.379,0.223c0.504,0.296,1.015,0.583,1.532,0.86c0.086,0.045,0.17,0.091,0.256,0.135
      c0.566,0.298,1.139,0.584,1.719,0.858c0.047,0.023,0.096,0.045,0.144,0.068c0.623,0.292,1.254,0.569,1.892,0.832
      c0.012,0.005,0.025,0.01,0.036,0.015c0.663,0.273,1.333,0.53,2.012,0.77V280.615z M315.077,201.846
      c-0.458,0-0.908-0.028-1.355-0.069c-0.153-0.014-0.303-0.035-0.454-0.054c-0.293-0.036-0.585-0.081-0.872-0.134
      c-0.172-0.031-0.345-0.064-0.515-0.102c-0.279-0.062-0.552-0.135-0.824-0.213c-0.154-0.043-0.31-0.082-0.463-0.13
      c-0.39-0.124-0.773-0.266-1.148-0.421c-0.156-0.064-0.306-0.139-0.459-0.209c-0.246-0.112-0.489-0.227-0.728-0.351
      c-0.155-0.081-0.307-0.166-0.46-0.252c-0.246-0.14-0.487-0.288-0.725-0.441c-0.121-0.078-0.244-0.155-0.362-0.236
      c-0.725-0.5-1.405-1.061-2.029-1.68c-0.047-0.047-0.093-0.096-0.139-0.145c-0.269-0.274-0.527-0.557-0.774-0.852
      c-0.054-0.064-0.107-0.129-0.161-0.195c-0.246-0.304-0.481-0.617-0.703-0.94c-0.032-0.047-0.067-0.094-0.099-0.141
      c-0.502-0.748-0.935-1.545-1.296-2.381c-0.042-0.098-0.08-0.201-0.12-0.3c-0.692-1.708-1.083-3.571-1.083-5.526
      c0-8.157-6.613-14.769-14.769-14.769s-14.769,6.613-14.769,14.769c0,1.953-0.39,3.816-1.082,5.525
      c-0.04,0.1-0.078,0.204-0.121,0.302c-0.36,0.836-0.794,1.632-1.296,2.38c-0.033,0.048-0.067,0.094-0.099,0.141
      c-0.223,0.323-0.457,0.636-0.703,0.94c-0.053,0.065-0.106,0.13-0.16,0.195c-0.247,0.294-0.505,0.578-0.774,0.852
      c-0.046,0.047-0.092,0.097-0.139,0.145c-0.623,0.618-1.304,1.18-2.028,1.68c-0.119,0.082-0.241,0.159-0.362,0.236
      c-0.237,0.154-0.479,0.3-0.725,0.441c-0.152,0.086-0.304,0.171-0.46,0.252c-0.238,0.124-0.482,0.239-0.727,0.351
      c-0.154,0.07-0.304,0.145-0.46,0.209c-0.375,0.156-0.758,0.296-1.148,0.42c-0.153,0.048-0.308,0.086-0.463,0.13
      c-0.272,0.077-0.545,0.151-0.824,0.213c-0.17,0.038-0.343,0.071-0.515,0.102c-0.288,0.053-0.579,0.097-0.873,0.134
      c-0.152,0.019-0.302,0.04-0.454,0.054c-0.447,0.041-0.898,0.069-1.355,0.069c-0.457,0-0.908-0.028-1.355-0.069
      c-0.153-0.014-0.303-0.035-0.454-0.054c-0.293-0.036-0.585-0.081-0.873-0.134c-0.172-0.031-0.345-0.064-0.515-0.102
      c-0.279-0.062-0.552-0.135-0.824-0.213c-0.154-0.043-0.31-0.082-0.463-0.13c-0.39-0.124-0.773-0.266-1.148-0.421
      c-0.156-0.064-0.306-0.139-0.459-0.209c-0.246-0.112-0.489-0.226-0.728-0.351c-0.155-0.081-0.307-0.166-0.46-0.252
      c-0.246-0.14-0.487-0.287-0.725-0.441c-0.121-0.078-0.244-0.155-0.362-0.236c-0.725-0.5-1.405-1.061-2.028-1.68
      c-0.047-0.047-0.093-0.096-0.139-0.145c-0.269-0.274-0.528-0.557-0.774-0.852c-0.054-0.064-0.107-0.129-0.16-0.195
      c-0.246-0.304-0.482-0.617-0.703-0.94c-0.032-0.047-0.067-0.094-0.099-0.141c-0.502-0.748-0.935-1.545-1.296-2.381
      c-0.042-0.099-0.08-0.201-0.12-0.3c-0.692-1.708-1.083-3.571-1.083-5.526c0-8.157-6.613-14.769-14.769-14.769
      s-14.769,6.613-14.769,14.769c0,1.953-0.39,3.816-1.082,5.525c-0.04,0.1-0.078,0.204-0.121,0.302
      c-0.36,0.836-0.794,1.633-1.296,2.38c-0.032,0.048-0.067,0.094-0.099,0.141c-0.223,0.323-0.457,0.636-0.703,0.94
      c-0.053,0.065-0.106,0.13-0.161,0.195c-0.247,0.294-0.505,0.578-0.774,0.852c-0.046,0.047-0.092,0.097-0.139,0.145
      c-0.623,0.618-1.304,1.18-2.028,1.68c-0.119,0.082-0.241,0.159-0.362,0.236c-0.237,0.154-0.479,0.3-0.725,0.441
      c-0.152,0.086-0.304,0.171-0.46,0.252c-0.238,0.124-0.481,0.239-0.727,0.351c-0.154,0.07-0.304,0.145-0.46,0.209
      c-0.375,0.156-0.758,0.296-1.148,0.42c-0.153,0.048-0.308,0.086-0.463,0.13c-0.272,0.077-0.545,0.151-0.824,0.213
      c-0.17,0.038-0.343,0.071-0.515,0.102c-0.289,0.053-0.579,0.097-0.873,0.134c-0.152,0.019-0.302,0.04-0.454,0.054
      c-0.447,0.041-0.898,0.069-1.355,0.069c-7.563,0-13.815-5.713-14.669-13.049l15.959-55.872h115.565l15.964,55.874
      C328.892,196.133,322.64,201.846,315.077,201.846z"></path></g></g></svg>
	</div>
</div>
<div class="w-full px-3">
<h3 class="text-base text-gray-700 font-semibold ">Location</h3>
<p class="text-sm text-gray-700 my-1 text-justify leading-loose">Every facility should be accounted for in the school and its location should be recorded. Using this module, every facility in all the places in the school will be linked to the tool and their status will be shown.</p>
</div>
</div>
</div>
<!-- **** -->
</div>
</div>
</div>
@endsection 