{{-- SPDX-License-Identifier: MIT --}}
@extends('layouts.main')

@section('title')
GegoK12 - school-notice-board-management | Online School Management 
@endsection

@section('content')
<div class="bg-red-600">
<div class="container mx-auto py-8 px-1">
	<h1 class="lg:text-4xl text-2xl font-bold text-center text-white">School Notice Board Management</h1>
</div>
</div>
<div class="container mx-auto">
<div class="leading-loose py-5 px-3">
<div class="flex flex-col lg:flex-row lg:items-center">
<div class="w-full lg:w-2/3">
	<p class="text-base text-gray-700 my-3">
	In this the Admin can publish notice boards, with publish & expire dates, for Teachers Group, Classes or Full School. Generally the notice board updates like Work Anniversary for Staffs, Today’s Birthday for Students, Today’s Birthday for Teachers and any kind of important details can be brought in to notice. You can enter details of Type Class, Title, Description, Publish Date, Expire Date, Attachment and Actions taken.
	</p>
	<p class="text-base text-gray-700 my-3">
	School notice board management system allows administration, staff and teachers for posting important notices to institute notice board instantly which can be seen easily by students, parents etc immediately.
	</p>
	<p class="text-base text-gray-700 my-3">
	It shows for incoming events, exhibition pictures, exam schedules, holiday notice, fee collection date, assignment submission date, academic report cards, grading, result out, transportation details, date sheet, class timetable section wise and many more important notices which needs to spread among all as soon as possible.
	</p>
	</div>
	<div class="w-full lg:w-1/3 lg:pl-10 py-5">
		<img src="{{url('images/img6.png')}}" style="height: 300px;">
	</div>
	</div>
	<h2 class="text-xl lg:text-2xl md:text-2xl text-gray-800 my-3 italic">Important Features of School Notice Board Management Software:</h2>

	<ul class="list-reset text-gray-700 px-4 lg:px-10 md:px-10 text-sm lg:text-base md:text-base">
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Immediate posting of all type of message on the notice board.</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Students, parents, teachers and all stakeholders can easily go through the notices as soon as they get notified.</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Administrators can automatically set to activate/deactivate a given notice </span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Also users can manually activate/deactivate the notices in case the school wants notice removal in case of wrong message.</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Can add latest information in news feed section and events going to happen in school and send information among all functional departments.</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Noticeboard can effectively be used to provide highlights such as any sports competition, trip, tours, vacations, camp, health camps etc.</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Perfect for modern schools</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">Built with simple interface and ease-of-use at its core</span>
		</li>
		<li class="flex items-center py-2">
		<svg class="w-4 h-4 fill-current text-red-600" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M507.606,163.996L348.004,4.396c-5.857-5.857-15.356-5.857-21.213,0l-68.163,68.164c-5.858,5.857-5.858,15.355,0,21.213
			l12.113,12.113l-51.622,51.621c-12.194-2.613-24.657-3.934-37.16-3.934c-47.115,0-91.4,18.34-124.7,51.642
			c-5.857,5.858-5.857,15.355,0,21.213l71.415,71.413L2.487,488.725c-3.931,5.946-3.134,13.838,1.907,18.878
			c2.898,2.898,6.739,4.393,10.611,4.393c2.861,0,5.74-0.816,8.267-2.487l190.887-126.186l71.417,71.416
			c2.813,2.814,6.629,4.394,10.607,4.394c3.979,0,7.794-1.581,10.607-4.394c22.281-22.283,38.198-50.109,46.03-80.469
			c6.863-26.604,7.417-54.563,1.671-81.391l51.621-51.624l12.118,12.118c2.813,2.814,6.628,4.394,10.607,4.394
			c3.979,0,7.794-1.58,10.606-4.394l68.163-68.165C513.464,179.351,513.464,169.853,507.606,163.996z M68.052,443.946
			l82.272-124.454l42.182,42.184L68.052,443.946z M327.34,277.605c-3.786,3.786-5.267,9.302-3.887,14.475
			c12.156,45.546,1.492,94.17-27.821,130.29L89.613,216.354c26.019-21.238,58.291-32.782,92.346-32.782
			c12.826,0,25.598,1.673,37.96,4.973c5.175,1.38,10.689-0.101,14.475-3.887l57.56-57.559l92.944,92.944L327.34,277.605z
			 M428.837,221.554L290.447,83.168l46.951-46.952l138.39,138.387L428.837,221.554z"/>
	</g>
</g></svg>
		<span class="mx-3 w-full">It keep students, parents, and faculties informed about the recent activities, updates or important announcements</span>
		</li>
	</ul>
	
</div>
</div>
@endsection 