{{-- SPDX-License-Identifier: MIT --}}
<ul class="list-reset text-sm">
    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'dashboard' ? 'active':''}}">
        <a href="{{url('student/dashboard')}}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/dashboard.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512px" height="512px"><g><g><g><g><path d="M256,298.66c-10.527,0.031-20.665,3.982-28.437,11.083l-72.896-41.685c-5.116-2.946-11.652-1.186-14.597,3.931     c-2.945,5.116-1.186,11.652,3.931,14.597l71.755,41.003c-1.565,4.413-2.383,9.056-2.421,13.739     c0,23.564,19.102,42.667,42.667,42.667s42.667-19.102,42.667-42.667C298.667,317.762,279.564,298.66,256,298.66z M256,362.66 c-11.782,0-21.333-9.551-21.333-21.333c0-11.782,9.551-21.333,21.333-21.333c11.782,0,21.333,9.551,21.333,21.333 C277.333,353.109,267.782,362.66,256,362.66z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M436.501,158.233c-50.187-48.853-117.141-74.549-187.68-72.811C111.616,89.103,0,203.727,0,340.975v57.227     c0.123,15.799,13,28.524,28.8,28.459h454.4c15.796,0.065,28.671-12.653,28.8-28.448v-62.219     C512,268.793,485.184,205.625,436.501,158.233z M490.667,398.233c-0.116,4.018-3.448,7.192-7.467,7.115H28.8     c-4.019,0.078-7.35-3.097-7.467-7.115v-57.259c0-125.781,102.304-230.869,228.053-234.229     c64.12-2.218,126.352,21.907,172.224,66.763c44.523,43.36,69.056,101.056,69.056,162.485V398.233z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M256,181.327c5.891,0,10.667-4.776,10.667-10.667v-42.667c0-5.891-4.776-10.667-10.667-10.667     c-5.891,0-10.667,4.776-10.667,10.667v42.667C245.333,176.551,250.109,181.327,256,181.327z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M416,341.327c0,5.891,4.776,10.667,10.667,10.667h42.667c5.891,0,10.667-4.776,10.667-10.667     s-4.776-10.667-10.667-10.667h-42.667C420.776,330.66,416,335.436,416,341.327z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M85.333,330.66H42.667c-5.891,0-10.667,4.776-10.667,10.667s4.776,10.667,10.667,10.667h42.667     c5.891,0,10.667-4.776,10.667-10.667S91.224,330.66,85.333,330.66z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M160.491,195.193c2.993,5.075,9.533,6.763,14.608,3.771c5.075-2.993,6.763-9.533,3.771-14.608l-18.133-30.795     c-2.993-5.075-9.533-6.763-14.608-3.771c-5.075,2.993-6.763,9.533-3.771,14.608L160.491,195.193z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M396.224,256.783c2.893,5.13,9.397,6.945,14.528,4.053l31.477-17.771c5.179-2.807,7.102-9.281,4.295-14.46     c-2.807-5.179-9.281-7.102-14.46-4.295c-0.104,0.056-0.207,0.115-0.31,0.175l-31.477,17.771     C395.147,245.148,393.332,251.651,396.224,256.783z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M111.723,242.244h0.011l-31.488-17.771c-5.083-2.978-11.618-1.272-14.596,3.811c-2.978,5.083-1.272,11.617,3.811,14.596 c0.102,0.06,0.206,0.118,0.31,0.175l31.477,17.771c5.179,2.807,11.654,0.884,14.46-4.296     C118.449,251.472,116.686,245.152,111.723,242.244z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="M365.915,149.782c-0.016-0.01-0.032-0.019-0.048-0.028c-5.075-2.989-11.612-1.298-14.603,3.776l-18.133,30.795     c-3.001,5.075-1.32,11.623,3.755,14.624c5.075,3.001,11.623,1.32,14.624-3.755l18.133-30.795     C372.65,159.333,370.981,152.788,365.915,149.782z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g></g></g></svg>

            <span class="mx-3 whitespace-no-wrap">Dashboard</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'homework' ? 'active':''}} && {{Request::segment ('2') == 'homeworks' ? 'active':''}}">
        <a href="{{url('student/homeworks')}}" class="flex items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Capa_1" enable-background="new 0 0 512 512" height="512px" viewBox="0 0 512 512" width="512px"><g><g><path d="m74.791 114.523c26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.441.561-16.425-6.881-20.067-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.115 8.283 6.507 15.091 14.79 15.207z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 176.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m202.593 236.126c-51.852-25.374-97.892-31.189-127.384-31.6-.071-.001-.143-.001-.213-.001-8.187 0-14.88 6.579-14.994 14.791-.116 8.284 6.506 15.092 14.789 15.208 26.424.368 67.758 5.62 114.616 28.55 7.392 3.619 16.401.608 20.066-6.88 3.641-7.443.561-16.427-6.88-20.068z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m309.407 116.126c-7.441 3.641-10.521 12.625-6.881 20.067 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 37.64-18.419 75.865-28.024 113.616-28.55 8.283-.115 14.905-6.924 14.789-15.208-.115-8.283-6.876-14.901-15.207-14.79-42.213.589-84.735 11.221-126.383 31.601z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m500.638 7.584c-18.59-4.713-37.148-7.584-60.591-7.584-.016 0-.035 0-.05 0-43.627.009-110.281 11.25-183.997 63.569-73.272-52-139.55-63.382-182.937-63.566-24.136-.104-43.055 2.852-61.7 7.581-6.678 1.67-11.363 7.669-11.363 14.552v294.5c0 4.619 2.128 8.98 5.769 11.823 6.635 5.182 13.606 2.463 13.981 2.448 41.952-10.63 127.258-17.266 227.25 57.729 2.667 2 5.833 3 9 3s6.333-1 9-3c31.188-23.391 63.401-40.556 96-51.235v159.599c0 8.284 6.716 15 15 15h60c8.284 0 15-6.716 15-15v-172.236c21.132 1.097 36.088 4.848 41.675 6.252.277.008 7.061 2.515 13.557-2.557 3.641-2.843 5.769-7.204 5.769-11.823v-294.5c-.001-6.883-4.685-12.882-11.363-14.552zm-470.638 290.414v-263.956c9.661-1.955 24.286-4.124 42.937-4.04 39.466.168 100.214 10.809 168.063 59.726v258.166c-45.801-29.614-93.332-47.095-141.641-52.035-29.797-3.047-53.622-.62-69.359 2.139zm385.485-56.998h-18.969l9.484-29.8zm5.515 241h-30v-211h30zm61-183.931c-8.266-1.429-18.763-2.783-31-3.342v-38.667c.009-1.64-.255-3.321-.813-4.942l-29.894-93.926c-2.22-6.938-9.127-11.275-16.273-10.32-31.752 4.227-63.585 14.069-94.613 29.253-7.441 3.641-10.521 12.625-6.881 20.066 2.604 5.32 7.937 8.41 13.484 8.41 2.213 0 4.461-.492 6.582-1.53 20.297-9.932 40.912-17.319 61.544-22.097l-22.324 70.143c-.521 1.513-.806 3.135-.813 4.823v50.053c-30.537 8.934-60.681 22.965-90 41.91v-258.175c68.249-49.206 129.329-59.72 169.004-59.728h.043c18.182 0 32.464 2.124 41.954 4.043z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Homework</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'assignments' ? 'active':''}} && {{Request::segment ('2') == 'assignment' ? 'active':''}}">
        <a href="{{url('student/assignments')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Layer_27" data-name="Layer 27"><path d="m62 29h-24a1 1 0 0 0 -1 1v3.61a12.09 12.09 0 0 0 -6-1.61h-3v-2a10 10 0 0 0 3.83-6h.17a4 4 0 0 0 3-6.62v-3.38a13 13 0 0 0 -26 0v3.38a4 4 0 0 0 3 6.62h.2a10 10 0 0 0 3.8 6v2h-3a12 12 0 0 0 -12 12v18a1 1 0 0 0 1 1h33v-2h-8.15l-2.85-16.84 1.21-2.42 2.3 1.15a1 1 0 0 0 .49.11 1 1 0 0 0 .95-.68l2.76-8.32a10 10 0 0 1 5.29 2v26a1 1 0 0 0 1 1h24a1 1 0 0 0 1-1v-32a1 1 0 0 0 -1-1zm-30-7v-4a2 2 0 0 1 0 4zm-22-2a2 2 0 0 1 2-2v4a2 2 0 0 1 -2-2zm2-4a4.09 4.09 0 0 0 -1 .14v-2.14a11 11 0 0 1 22 0v2.14a4.09 4.09 0 0 0 -1-.14 1 1 0 0 0 -1-1 5 5 0 0 1 -4-2l-1.2-1.6a1 1 0 0 0 -1.6 0l-1.2 1.6a5 5 0 0 1 -4 2h-6a1 1 0 0 0 -1 1zm2 6v-5h5a7 7 0 0 0 5.6-2.8l.4-.53.4.53a7.06 7.06 0 0 0 4.6 2.73v5.07a8 8 0 0 1 -16 0zm8 10a9.92 9.92 0 0 0 4-.84v1.48l-4 4.8-4-4.8v-1.48a9.92 9.92 0 0 0 4 .84zm-5.42 8.59-2.19-6.59h2.14l3.89 4.67zm-13.58 3.41a10 10 0 0 1 9.29-10l2.76 8.28a1 1 0 0 0 .95.72 1 1 0 0 0 .45-.11l2.3-1.15 1.25 2.42-2.85 16.84h-8.15v-14h-2v14h-4zm16.18 17 2.67-16h.3l2.67 16zm3.2-18h-.76l-1.08-2.15 1.46-.73 1.46.73zm5-2.41-3.84-1.92 3.93-4.67h2.14zm17.62-9.59h10v2h-10zm16 30h-22v-30h4v3a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-3h4z"/><path d="m46 37h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 45h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 53h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m49 37h10v2h-10z"/><path d="m49 41h10v2h-10z"/><path d="m49 45h10v2h-10z"/><path d="m49 49h10v2h-10z"/><path d="m49 53h10v2h-10z"/><path d="m49 57h10v2h-10z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Assignment</span>
        </a>
    </li>
    @if(config('gquiz.enabled', false))
    <li class="py-3 px-3 {{Request::segment ('2') == 'quiz' ? 'active':''}}">
        <a href="{{url('/student/quiz')}}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="512" height="512"><g id="XMLID_1203_"><g id="XMLID_1116_"><g id="XMLID_386_"><path id="XMLID_387_" d="M171.759,128h14.518c5.522,0,10-4.477,10-10s-4.478-10-10-10h-14.518c-1.266,0-2.296-1.03-2.296-2.296     V96h12.993c5.522,0,10-4.477,10-10s-4.478-10-10-10h-12.993v-9.704c0-1.266,1.03-2.296,2.296-2.296h14.518     c5.522,0,10-4.477,10-10s-4.478-10-10-10h-14.518c-12.294,0-22.296,10.002-22.296,22.296v39.408     C149.463,117.998,159.465,128,171.759,128z"/><path id="XMLID_388_" d="M239.254,108h-17.167c-5.522,0-10,4.477-10,10s4.478,10,10,10h17.167c14.337,0,26-11.664,26-26     s-11.663-26-26-26h-1.167c-3.309,0-6-2.691-6-6s2.691-6,6-6h11.512c5.522,0,10-4.477,10-10s-4.478-10-10-10h-11.512     c-14.337,0-26,11.664-26,26s11.663,26,26,26h1.167c3.309,0,6,2.691,6,6S242.563,108,239.254,108z"/><path id="XMLID_389_" d="M129.254,44h-33c-5.522,0-10,4.477-10,10s4.478,10,10,10h6.5v54c0,5.523,4.478,10,10,10s10-4.477,10-10     V64h6.5c5.522,0,10-4.477,10-10S134.777,44,129.254,44z"/><path id="XMLID_390_" d="M288.754,64h6.5v54c0,5.523,4.478,10,10,10s10-4.477,10-10V64h6.5c5.522,0,10-4.477,10-10     s-4.478-10-10-10h-33c-5.522,0-10,4.477-10,10S283.232,64,288.754,64z"/><path id="XMLID_895_" d="M120.462,168h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40     C130.462,172.477,125.985,168,120.462,168z M110.462,208h-20v-20h20V208z"/><path id="XMLID_896_" d="M323.626,218c0,2.63,1.069,5.21,2.93,7.07s4.44,2.93,7.07,2.93s5.21-1.07,7.069-2.93 c1.87-1.86,2.931-4.44,2.931-7.07c0-2.63-1.061-5.21-2.931-7.07c-1.859-1.86-4.43-2.93-7.069-2.93c-2.63,0-5.21,1.07-7.07,2.93     C324.695,212.79,323.626,215.37,323.626,218z"/><path id="XMLID_897_" d="M293.629,208h-133.5c-5.522,0-10,4.477-10,10s4.478,10,10,10h133.5c5.522,0,10-4.477,10-10     S299.152,208,293.629,208z"/><path id="XMLID_941_" d="M120.462,272h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40     C130.462,276.477,125.985,272,120.462,272z M110.462,312h-20v-20h20V312z"/><path id="XMLID_982_" d="M120.462,376h-40c-5.522,0-10,4.477-10,10v40c0,5.523,4.478,10,10,10h40c5.522,0,10-4.477,10-10v-40     C130.462,380.477,125.985,376,120.462,376z M110.462,416h-20v-20h20V416z"/><path id="XMLID_983_" d="M246.004,416h-85.875c-5.522,0-10,4.477-10,10s4.478,10,10,10h85.875c5.522,0,10-4.477,10-10     S251.527,416,246.004,416z"/><path id="XMLID_1111_" d="M486.004,79.59c-8.791-5.076-19.033-6.423-28.836-3.796c-9.805,2.627-17.999,8.915-23.073,17.706 l-9.625,16.67l0,0.001l0,0.001l-13.465,23.323V34c0-18.748-15.252-34-34-34h-336c-18.748,0-34,15.252-34,34v444 c0,18.748,15.252,34,34,34h336c18.748,0,34-15.252,34-34V287c0-0.454-0.041-0.897-0.1-1.335l79.383-137.495l9.625-16.671 C510.389,113.353,504.15,90.067,486.004,79.59z M462.345,95.112c4.644-1.246,9.495-0.606,13.659,1.798 c8.596,4.963,11.551,15.993,6.588,24.589l-4.625,8.011l-31.177-18l4.625-8.011C453.82,99.335,457.7,96.356,462.345,95.112z M340.627,367.39l-31.177-18l127.34-220.56l31.177,18L340.627,367.39z M303.717,369.173l22.644,13.074l-27.213,20.988 L303.717,369.173z M391.004,478c0,7.72-6.28,14-14,14h-336c-7.72,0-14-6.28-14-14V34c0-7.72,6.28-14,14-14h336 c7.72,0,14,6.28,14,14v134c0,0.042,0.006,0.082,0.006,0.123L307.944,312H160.129c-5.522,0-10,4.477-10,10s4.478,10,10,10h136.268     l-9.267,16.05c-0.652,1.13-1.077,2.377-1.251,3.67l-9.786,72.95c-0.539,4.018,1.4,7.963,4.911,9.99 c1.554,0.897,3.279,1.34,4.999,1.34c2.164,0,4.319-0.702,6.108-2.082l58.283-44.95c1.033-0.797,1.9-1.789,2.553-2.918     l38.057-65.916V478z"/></g></g></g></svg>

            <span class="mx-3 whitespace-no-wrap">Online Assessment</span>
        </a>
    </li>
    @endif

   @if(config('gvideoroom.enabled', false))
    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'video-conference' ? 'active':''}}">
        <a href="{{url('student/video-conference')}}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/dashboard.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" id="_x31_" enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><g><g id="XMLID_1_"><path d="m16 15.5v4c0-.3-.2-.5-.5-.5h-.5v-3.5c0-.3.2-.5.5-.5s.5.2.5.5z"/><path d="m15.5 19c.3 0 .5.2.5.5s-.2.5-.5.5h-.5v-1z"/><path d="m15 19v1h-3.5c.3 0 .5-.2.5-.5v-.5z"/><path d="m23 11.4v-4.8l-2.2 1.8c-.1.1-.4.1-.5.1-.2-.1-.3-.3-.3-.5v-1.5c0-.3-.2-.5-.5-.5h-6c-.3 0-.5.2-.5.5v5c0 .3.2.5.5.5h6c.3 0 .5-.2.5-.5v-1.5c0-.2.1-.4.3-.4.2-.1.4-.1.5.1zm-2 .1c0 .8-.7 1.5-1.5 1.5h-4-2c-.8 0-1.5-.7-1.5-1.5v-5c0-.8.7-1.5 1.5-1.5h2 4c.8 0 1.5.7 1.5 1.5v.4l2.2-1.8c.1-.1.3-.1.5 0 .2 0 .3.2.3.4v7c0 .2-.1.4-.3.4-.1 0-.1.1-.2.1s-.2 0-.3-.1l-2.2-1.8z"/><path d="m11 19.5v-.5h1v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5z"/><path d="m11.5 20h-7c.3 0 .5-.2.5-.5v-.5h6v.5c0 .3.2.5.5.5z"/><path d="m6 13c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zm3 0c0-.6-.4-1-1-1s-1 .4-1 1 .4 1 1 1 1-.4 1-1z"/><path d="m5 19v.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-.5z"/><path d="m4 18.5c0-1.4 1.1-2.5 2.5-2.5h3c1.4 0 2.5 1.1 2.5 2.5v.5h-1v-.5c0-.8-.7-1.5-1.5-1.5h-3c-.8 0-1.5.7-1.5 1.5v.5h-1z"/><path d="m1 20v-1h3v.5c0 .3.2.5.5.5z"/><path d="m1 19v1h-.5c-.3 0-.5-.2-.5-.5s.2-.5.5-.5z"/><path d="m0 2.5c0-1.4 1.1-2.5 2.5-2.5h11c1.4 0 2.5 1.1 2.5 2.5 0 .3-.2.5-.5.5s-.5-.2-.5-.5c0-.8-.7-1.5-1.5-1.5h-11c-.8 0-1.5.7-1.5 1.5v16.5h-.5c-.3 0-.5.2-.5.5z"/><path d="m15 20h.5c.3 0 .5-.2.5-.5v2c0 1.4-1.1 2.5-2.5 2.5h-11c-1.4 0-2.5-1.1-2.5-2.5v-2c0 .3.2.5.5.5h.5v1.5c0 .8.7 1.5 1.5 1.5h11c.8 0 1.5-.7 1.5-1.5z"/></g></g></svg>

            <span class="mx-3 whitespace-no-wrap">Video Room</span>
        </a>
    </li>
@endif
    <li class="py-3 px-3 hover:bg-purple-900 {{Request::segment ('2') == 'tasks' ? 'active':''}} || {{Request::segment ('2') == 'task' ? 'active':''}}">
        <a href="{{url('/student/tasks')}}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>

            <!-- <img src="{{asset('uploads/icons/sidebar/activity.svg')}}" class="w-5 h-5"> -->
            <span class="mx-3 whitespace-no-wrap">To Do List</span>
        </a>
    </li>


    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'events' ? 'active':''}}">
        <a href="{{url('student/events')}}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/calendar.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="0 0 480 480" width="512px"><g><path d="m399.832031 54.398438c-.0625-.277344-.230469-.496094-.3125-.757813-.136719-.449219-.316406-.882813-.535156-1.296875-.25-.476562-.550781-.921875-.894531-1.335938-.277344-.34375-.582032-.664062-.914063-.960937-.402343-.339844-.84375-.632813-1.3125-.878906-.394531-.238281-.8125-.441407-1.246093-.609375-.519532-.164063-1.058594-.273438-1.601563-.328125-.332031-.097657-.671875-.175781-1.015625-.230469h-40.335938c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-16.671876c-2.0625-27.847656-14.984374-48-31.664062-48s-29.601562 20.152344-31.664062 48h-40.335938c-4.417969 0-8 3.582031-8 8v416c0 4.417969 3.582031 8 8 8h384c4.417969 0 8-3.582031 8-8v-24h72c2.402344 0 4.675781-1.082031 6.191406-2.941406 1.519532-1.863282 2.121094-4.304688 1.640625-6.660156zm-79.832031-38.398438c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-80 0c5.777344 0 13.839844 12.257812 15.617188 32h-31.203126c1.746094-19.742188 9.808594-32 15.585938-32zm-64 48h32.335938c2.0625 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h63.953126c2.089843 27.847656 14.984374 48 31.664062 48 4.417969 0 8-3.582031 8-8s-3.582031-8-8-8c-5.777344 0-13.839844-12.257812-15.617188-32h79.617188v80h-368zm368 400h-368v-304h368zm16-32v-298.398438l62.167969 298.398438zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m176 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m256 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 288h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 368h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m336 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m96 208h-32c-4.417969 0-8 3.582031-8 8v32c0 4.417969 3.582031 8 8 8h32c4.417969 0 8-3.582031 8-8v-32c0-4.417969-3.582031-8-8-8zm-8 32h-16v-16h16zm0 0" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Calendar</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'notices' ? 'active':''}} || {{Request::segment ('2') == 'notice' ? 'active':''}} ">
        <a href="{{ url('/student/notices') }}" class="flex items-center">
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Layer_3" enable-background="new 0 0 64 64" height="512px" viewBox="0 0 64 64" width="512px"><g><path d="m21 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m35 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 51h26c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1zm1-4h24v2h-24z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 53h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 57h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m62 9c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-12v-1c0-.553-.447-1-1-1h-34c-.553 0-1 .447-1 1v1h-12c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h1v46h-1c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h12v1c0 .553.447 1 1 1h34c.553 0 1-.447 1-1v-1h12c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-1v-46zm-59-4h11v2h-11zm11 4v46h-5v-46zm-9 0h2v46h-2zm-2 50v-2h11v2zm45 2h-32v-58h32zm13-56v2h-11v-2zm-11 50v-46h5v46zm11 4h-11v-2h11zm-2-4h-2v-46h2z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 31h26c.553 0 1-.447 1-1v-24c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v24c0 .553.447 1 1 1zm10-17c0-1.654 1.346-3 3-3s3 1.346 3 3-1.346 3-3 3-3-1.346-3-3zm8 15h-10v-5c0-2.757 2.243-5 5-5s5 2.243 5 5zm-17-22h24v22h-5v-5c0-2.698-1.537-5.04-3.779-6.208 1.079-.918 1.779-2.268 1.779-3.792 0-2.757-2.243-5-5-5s-5 2.243-5 5c0 1.524.7 2.874 1.779 3.792-2.242 1.168-3.779 3.51-3.779 6.208v5h-5z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Notice Board</span>
        </a>
    </li>
    
    @if(config('gchat.enabled', false))
    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'chats' ? 'active':''}} && {{Request::segment ('2') == 'chat' ? 'active':''}}">
        <a href="{{url('student/chats')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 417.986 417.986" style="enable-background:new 0 0 417.986 417.986;" xml:space="preserve"><g><g><g><path d="M371.514,19.619c-1.062-0.035-2.125-0.035-3.188,0H126.433c-28.735,0-53.29,20.898-53.29,49.633v117.551H28.735 C11.494,186.802,0,202.476,0,219.716v97.176c0,17.241,11.494,31.869,28.735,31.869h23.51l9.404,41.796 c0.909,3.707,3.679,6.674,7.314,7.837h3.135c2.756-0.039,5.385-1.166,7.314-3.135l42.841-46.498h64.784 c17.575-0.27,31.836-14.301,32.392-31.869V265.17h7.837l71.575,77.845c1.698,2.336,4.427,3.7,7.314,3.657h3.135 c3.559-0.976,6.339-3.756,7.314-7.314l16.718-74.188h35.004c28.735,0,49.633-24.555,49.633-53.29V69.251 C418.839,42.72,398.045,20.499,371.514,19.619z M198.531,316.892c-0.521,6.03-5.446,10.731-11.494,10.971h-69.486 c-2.756,0.039-5.385,1.166-7.314,3.135l-32.914,35.526L70.531,335.7c-1.22-4.735-5.561-7.991-10.449-7.837H28.735 c-5.747,0-7.837-5.224-7.837-10.971v-97.176c0-5.747,2.09-12.016,7.837-12.016h44.408v4.18 c0.556,29.198,24.092,52.734,53.29,53.29h72.098V316.892z M397.061,69.251V211.88c0,17.241-11.494,32.392-28.735,32.392h-43.363 c-4.834-0.335-9.131,3.057-9.927,7.837l-14.106,62.171l-61.649-66.873c-1.929-1.969-4.558-3.095-7.314-3.135H126.433 c-17.659-0.544-31.848-14.732-32.392-32.392V69.251c0-17.241,15.151-28.735,32.392-28.735h241.894 c14.978-0.892,27.843,10.526,28.735,25.504C397.125,67.096,397.125,68.175,397.061,69.251z"/><path d="M140.539,118.884h125.388c5.771,0,10.449-4.678,10.449-10.449s-4.678-10.449-10.449-10.449H140.539 c-5.771,0-10.449,4.678-10.449,10.449S134.768,118.884,140.539,118.884z"/><path d="M349.518,160.68h-208.98c-5.771,0-10.449,4.678-10.449,10.449s4.678,10.449,10.449,10.449h208.98 c5.771,0,10.449-4.678,10.449-10.449S355.289,160.68,349.518,160.68z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Chat Room</span>
        </a>
    </li>
    @endif

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'holidays' ? 'active':''}} && {{Request::segment ('2') == 'holiday' ? 'active':''}}">
        <a href="{{url('student/holidays')}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g id="Layer_27" data-name="Layer 27"><path d="m62 29h-24a1 1 0 0 0 -1 1v3.61a12.09 12.09 0 0 0 -6-1.61h-3v-2a10 10 0 0 0 3.83-6h.17a4 4 0 0 0 3-6.62v-3.38a13 13 0 0 0 -26 0v3.38a4 4 0 0 0 3 6.62h.2a10 10 0 0 0 3.8 6v2h-3a12 12 0 0 0 -12 12v18a1 1 0 0 0 1 1h33v-2h-8.15l-2.85-16.84 1.21-2.42 2.3 1.15a1 1 0 0 0 .49.11 1 1 0 0 0 .95-.68l2.76-8.32a10 10 0 0 1 5.29 2v26a1 1 0 0 0 1 1h24a1 1 0 0 0 1-1v-32a1 1 0 0 0 -1-1zm-30-7v-4a2 2 0 0 1 0 4zm-22-2a2 2 0 0 1 2-2v4a2 2 0 0 1 -2-2zm2-4a4.09 4.09 0 0 0 -1 .14v-2.14a11 11 0 0 1 22 0v2.14a4.09 4.09 0 0 0 -1-.14 1 1 0 0 0 -1-1 5 5 0 0 1 -4-2l-1.2-1.6a1 1 0 0 0 -1.6 0l-1.2 1.6a5 5 0 0 1 -4 2h-6a1 1 0 0 0 -1 1zm2 6v-5h5a7 7 0 0 0 5.6-2.8l.4-.53.4.53a7.06 7.06 0 0 0 4.6 2.73v5.07a8 8 0 0 1 -16 0zm8 10a9.92 9.92 0 0 0 4-.84v1.48l-4 4.8-4-4.8v-1.48a9.92 9.92 0 0 0 4 .84zm-5.42 8.59-2.19-6.59h2.14l3.89 4.67zm-13.58 3.41a10 10 0 0 1 9.29-10l2.76 8.28a1 1 0 0 0 .95.72 1 1 0 0 0 .45-.11l2.3-1.15 1.25 2.42-2.85 16.84h-8.15v-14h-2v14h-4zm16.18 17 2.67-16h.3l2.67 16zm3.2-18h-.76l-1.08-2.15 1.46-.73 1.46.73zm5-2.41-3.84-1.92 3.93-4.67h2.14zm17.62-9.59h10v2h-10zm16 30h-22v-30h4v3a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-3h4z"/><path d="m46 37h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 45h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m46 53h-4a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-4a1 1 0 0 0 -1-1zm-1 4h-2v-2h2z"/><path d="m49 37h10v2h-10z"/><path d="m49 41h10v2h-10z"/><path d="m49 45h10v2h-10z"/><path d="m49 49h10v2h-10z"/><path d="m49 53h10v2h-10z"/><path d="m49 57h10v2h-10z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Holiday</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'libraryactivity' ? 'active':''}}">
        <a href="{{url('/student/libraryactivity')}}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m512 174.817v-30h-71.605c-24.813 0-45-20.187-45-45s20.187-45 45-45v-30h-278.79c-41.355 0-75 33.645-75 75 0 16.871 5.603 32.456 15.041 45h-26.646c-41.355 0-75 33.645-75 75 0 24.508 11.818 46.306 30.052 60-18.234 13.695-30.052 35.493-30.052 60 0 41.355 33.645 75 75 75h62.802v72.365l62.494-30.885 62.495 30.885v-72.365h249.209v-30c-24.813 0-45-20.187-45-45s20.187-45 45-45v-30c-24.813 0-45-20.187-45-45s20.187-45 45-45zm-395.395-75c0-24.813 20.187-45 45-45h218.83c-6.565 8.725-11.274 18.922-13.531 30h-197.522v30h197.522c2.258 11.078 6.967 21.275 13.531 30h-218.83c-24.813 0-45-20.186-45-45zm83.691 323.018-32.494 16.059v-84.076h64.989v84.076zm62.495-38.018v-30h175.718c2.258 11.078 6.967 21.275 13.531 30zm175.718-60h-355.733v30h55.025v30h-62.801c-24.813 0-45-20.187-45-45s20.187-45 45-45h377.041c-6.565 8.726-11.274 18.922-13.532 30zm-363.509-60c-24.813 0-45-20.187-45-45s20.187-45 45-45h377.041c-6.565 8.725-11.274 18.922-13.531 30h-355.734v30h355.733c2.258 11.078 6.967 21.275 13.531 30z"/></g></svg>
            <!-- <img src="{{asset('uploads/icons/sidebar/activity.svg')}}" class="w-5 h-5"> -->
    
            <span class="mx-3 whitespace-no-wrap">My Library Activity</span>
        </a>
    </li>

    <!-- class wall start -->
    @php
        $class='';
        $array=array('pages','page','posts','post');
        if(in_array(\Request()->segment('3'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3 hover:bg-teal-900 {{$class}}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_1153_"><g id="XMLID_452_"><path id="XMLID_957_" d="m469.885 359.996c23.343-.714 42.115-19.912 42.115-43.424v-253.084c0-23.963-19.495-43.458-43.458-43.458h-167.479c-5.522 0-10 4.477-10 10s4.478 10 10 10h167.479c12.935 0 23.458 10.523 23.458 23.458v253.084c0 12.487-9.808 22.723-22.124 23.417-2.993-24.73-24.097-43.959-49.622-43.959-25.539 0-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44s-46.652 19.25-49.627 44h-64.872c-2.975-24.75-24.089-44-49.627-44-25.529 0-46.636 19.236-49.624 43.973-12.436-.568-22.378-10.859-22.378-23.431v-253.084c0-12.935 10.523-23.458 23.458-23.458h167.605c5.522 0 10-4.477 10-10s-4.478-10-10-10h-167.605c-23.963 0-43.458 19.495-43.458 43.458v253.084c0 23.598 18.909 42.849 42.369 43.43 1.437 12.009 7.141 22.72 15.557 30.572-33.909 13.57-57.926 46.759-57.926 85.456v6c0 5.523 4.478 10 10 10h492c5.522 0 10-4.477 10-10v-6c0-38.629-23.933-71.769-57.748-85.383 8.459-7.859 14.194-18.602 15.633-30.651zm-79.631-13.966c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-100.091 44.581c8.43-7.849 14.147-18.564 15.591-30.581h64.872c1.438 11.961 7.11 22.633 15.477 30.472-20.849 8.292-37.973 23.996-48.104 43.841-10.086-19.76-27.108-35.412-47.836-43.732zm-64.036-44.581c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-4.112 44.508c-20.808 8.301-37.899 23.988-48.015 43.805-10.101-19.789-27.158-35.458-47.926-43.769 8.409-7.846 14.111-18.547 15.553-30.545h64.873c1.44 11.981 7.127 22.667 15.515 30.509zm-160.015-36.508v-8c0-16.542 13.458-30 30-30s30 13.458 30 30v8c0 16.542-13.458 30-30 30s-30-13.458-30-30zm-41.891 118c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm164 0c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68zm307.782 0h-143.782c2.083-37.847 33.532-68 71.891-68s69.808 30.153 71.891 68z"/><path id="XMLID_1515_" d="m151.855 98.03c-5.522 0-10 4.477-10 10v16.127h-16.755c-5.522 0-10 4.477-10 10s4.478 10 10 10h16.756v16.756c0 5.523 4.478 10 10 10s10-4.477 10-10v-16.756h16.127c5.522 0 10-4.477 10-10s-4.478-10-10-10h-16.127v-16.127c-.001-5.523-4.478-10-10.001-10z"/><path id="XMLID_1623_" d="m81.1 191.609c5.522 0 10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.1c-5.522 0-10 4.477-10 10s4.478 10 10 10h7.1v70c0 5.523 4.477 10 10 10z"/><path id="XMLID_1852_" d="m194.884 101.609c0 5.523 4.478 10 10 10h7.099v70c0 5.523 4.478 10 10 10s10-4.477 10-10v-80c0-5.523-4.478-10-10-10h-17.099c-5.523 0-10 4.477-10 10z"/><path id="XMLID_1853_" d="m288.333 184.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1921_" d="m288.333 116.03h159.667c5.522 0 10-4.477 10-10s-4.478-10-10-10h-159.667c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1922_" d="m64 252.03h384c5.522 0 10-4.477 10-10s-4.478-10-10-10h-384c-5.522 0-10 4.477-10 10s4.478 10 10 10z"/><path id="XMLID_1923_" d="m256.06 39.97c2.63 0 5.21-1.07 7.07-2.93 1.87-1.86 2.93-4.44 2.93-7.07 0-2.64-1.06-5.21-2.93-7.07-1.86-1.87-4.43-2.93-7.07-2.93-2.63 0-5.21 1.06-7.069 2.93-1.86 1.86-2.931 4.43-2.931 7.07 0 2.63 1.07 5.21 2.931 7.07 1.859 1.86 4.439 2.93 7.069 2.93z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap flex items-center justify-between w-10/12">Class Wall <img src="{{url('images/right-arrow.svg')}}" class="w-2 h-2"></span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'pages' ? 'active':''}} && {{Request::segment ('3') == 'page' ? 'active':''}} ">
                <a href="{{url('/student/classwall/pages')}}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 480 480" style="enable-background:new 0 0 480 480;" xml:space="preserve"><g><g><path d="M160,344h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,344,160,344z"/></g></g><g><g><path d="M384,344H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,344,384,344z"/></g></g><g><g><path d="M160,296h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,296,160,296z"/></g></g><g><g><path d="M384,296H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,296,384,296z"/></g></g><g><g><path d="M160,248h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,248,160,248z"/></g></g><g><g><path d="M384,248H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,248,384,248z"/></g></g><g><g><path d="M160,200h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,200,160,200z"/></g></g><g><g><path d="M384,200H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,200,384,200z"/></g></g><g><g><path d="M160,152h-16c-4.418,0-8,3.582-8,8s3.582,8,8,8h16c4.418,0,8-3.582,8-8S164.418,152,160,152z"/></g></g><g><g><path d="M384,152H192c-4.418,0-8,3.582-8,8s3.582,8,8,8h192c4.418,0,8-3.582,8-8S388.418,152,384,152z"/></g></g><g><g><path d="M439.896,119.496c-0.04-0.701-0.177-1.393-0.408-2.056c-0.088-0.256-0.152-0.504-0.264-0.752 c-0.389-0.87-0.931-1.664-1.6-2.344l-112-112c-0.68-0.669-1.474-1.211-2.344-1.6c-0.248-0.112-0.496-0.176-0.744-0.264 c-0.669-0.23-1.366-0.37-2.072-0.416C320.328,0.088,320.176,0,320,0H96c-4.418,0-8,3.582-8,8v24H48c-4.418,0-8,3.582-8,8v432 c0,4.418,3.582,8,8,8h336c4.418,0,8-3.582,8-8v-40h40c4.418,0,8-3.582,8-8V120C440,119.824,439.912,119.672,439.896,119.496z M328,27.312L412.688,112H328V27.312z M376,464H56V48h32v376c0,4.418,3.582,8,8,8h280V464z M424,416H104V16h208v104 c0,4.418,3.582,8,8,8h104V416z"/></g></g><g><g><path d="M192,72h-48c-4.418,0-8,3.582-8,8v48c0,4.418,3.582,8,8,8h48c4.418,0,8-3.582,8-8V80C200,75.582,196.418,72,192,72z M184,120h-32V88h32V120z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Pages</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('3') == 'posts' ? 'active':''}} && {{Request::segment ('3') == 'post' ? 'active':''}}">
                <a href="{{url('/student/classwall/posts')}}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M0,30v452h512V30H0z M482,452H30V120h452V452z M482,90H30V60h452V90z"/></g></g><g><g><path d="M271,160v252h181V160H271z M422,382H301V190h121V382z"/></g></g><g><g><rect x="60" y="160" width="181" height="30"/></g></g><g><g><rect x="60" y="220" width="121" height="30"/></g></g><g><g><rect x="60" y="300" width="181" height="30"/></g></g><g><g><rect x="60" y="360" width="121" height="30"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Posts</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold {{Request::segment ('2') == 'feeds' ? 'active':''}} || {{Request::segment ('2') == 'feed' ? 'active':''}} ">
                <a href="{{url('/student/feeds')}}" class="flex items-center">
                   <svg height="460pt" viewBox="-11 0 460 460.11908" width="460pt" xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 fill-current text-white"><path d="m204.636719 0h-3.378907c-13.730468 0-25.351562 11.054688-25.351562 24.785156v23.875l-72.027344-20.976562c-2.023437-.589844-4.199218-.347656-6.039062.675781-1.84375 1.027344-3.195313 2.746094-3.761719 4.777344l-93.714844 322.976562c-1.203125 4.253907 1.25 8.683594 5.496094 9.914063l322.988281 93.773437c4.226563 1.230469 8.65625-1.183593 9.917969-5.402343l10-34.398438h80.941406c4.476563-.03125 8.113281-3.625 8.199219-8.101562v-336.316407c0-4.417969-3.78125-7.582031-8.199219-7.582031h-188.175781l-11.625-3.898438v-39.316406c0-13.730468-11.539062-24.785156-25.269531-24.785156zm-12.730469 24.785156c0-4.90625 4.441406-8.785156 9.351562-8.785156h3.378907c4.910156 0 9.269531 3.878906 9.269531 8.785156v34.667969l-22-6.148437zm161.507812 379.214844 68.492188-235.332031v235.332031zm68.492188-320v35.890625l-125.265625-35.890625zm-6.78125 50.589844-89.402344 307.609375-307.660156-89.304688 89.46875-307.617187 106.375 30.835937v54.585938c0 4.972656-4.03125 9-9 9-4.972656 0-9-4.027344-9-9v-33.238281c0-4.417969-3.582031-8-8-8s-8 3.582031-8 8v33.238281c0 13.808593 11.191406 25 25 25 13.804688 0 25-11.191407 25-25v-49.9375zm0 0"></path></svg>
                    <span class="mx-3 whitespace-no-wrap">Feeds</span>
                </a>
            </li>
        </ul>
    </li>
    <!-- class wall end -->

    <li class="py-3 px-3 hover:bg-teal-900 {{Request::segment ('2') == 'activity' ? 'active':''}}">
        <a href="{{url('/student/activity')}}" class="flex  items-center">
            <svg class="w-5 h-5 fill-current text-white" xmlns="http://www.w3.org/2000/svg" height="512px" viewBox="-1 0 512 512" width="512px" class="w-5 h-5"><g><path d="m360 242.839844v-207.839844c0-19.300781-15.699219-35-35-35h-290c-19.300781 0-35 15.699219-35 35v381c0 19.300781 15.699219 35 35 35h227.148438c24.152343 36.710938 65.714843 61 112.851562 61 74.4375 0 135-60.5625 135-135 0-79.980469-69.660156-143.085938-150-134.160156zm-325 178.160156c-2.757812 0-5-2.242188-5-5v-381c0-2.757812 2.242188-5 5-5h290c2.757812 0 5 2.242188 5 5v214.722656c-14.539062 5.15625-27.941406 12.734375-39.71875 22.253906-3.734375-1.410156 6.6875-.976562-155.28125-.976562-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h128.484375c-6.320313 9.242188-11.523437 19.308594-15.410156 30h-113.074219c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h105.953125c-2.425781 20.433594-.191406 40.886719 6.414063 60zm340 61c-57.898438 0-105-47.101562-105-105s47.101562-105 105-105 105 47.101562 105 105-47.101562 105-105 105zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 121h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 181h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m135 241h150c8.285156 0 15-6.714844 15-15s-6.714844-15-15-15h-150c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 106c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 166c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 226c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 286c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m90 346c0 8.285156-6.714844 15-15 15s-15-6.714844-15-15 6.714844-15 15-15 15 6.714844 15 15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path><path d="m375 301c-8.285156 0-15 6.714844-15 15v45h-30c-8.285156 0-15 6.714844-15 15s6.714844 15 15 15h45c8.285156 0 15-6.714844 15-15v-60c0-8.285156-6.714844-15-15-15zm0 0" data-original="#000000" data-old_color="#000000" fill="#FFFFFF" class="active-path"></path></g></svg>
            <span class="mx-3 whitespace-no-wrap">Activity Log</span>
        </a>
    </li>
</ul>