{{-- SPDX-License-Identifier: MIT --}}
<ul class="list-reset text-sm">
    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'dashboard' ? 'active':'' }}">
        <a href="{{ url('/accountant/dashboard') }}" class="flex items-center">
            <svg class="w-5 h-5 text-white fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><g><path d="M366.292,215.99L241.417,325.781c-0.167,0.146-0.333,0.292-0.479,0.448c-4.042,4.021-6.271,9.385-6.271,15.104 c0,11.76,9.563,21.333,21.333,21.333c5.667,0,11.021-2.208,15.563-6.75l109.792-124.875c3.708-4.219,3.5-10.604-0.479-14.583 C376.896,212.49,370.542,212.281,366.292,215.99z"/><path d="M256,85.333c-141.167,0-256,114.844-256,256c0,26.479,4.104,52.688,12.167,77.917c1.417,4.417,5.521,7.417,10.167,7.417 h467.333c4.646,0,8.75-3,10.167-7.417C507.896,394.021,512,367.813,512,341.333C512,200.177,397.167,85.333,256,85.333z M458.667,352h31.26c-0.824,18.04-3.237,35.947-8.177,53.333H30.25c-4.94-17.387-7.353-35.293-8.177-53.333h31.26 C59.229,352,64,347.229,64,341.333c0-5.896-4.771-10.667-10.667-10.667h-31.46c1.581-34.919,10.68-67.865,25.948-97.208 l27.324,15.781c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.906,9.229-5.333c2.958-5.104,1.208-11.625-3.896-14.573 l-27.263-15.746c18.323-28.539,42.602-52.816,71.142-71.138l15.746,27.28c1.958,3.417,5.563,5.333,9.229,5.333 c1.813,0,3.646-0.458,5.333-1.427c5.104-2.948,6.854-9.469,3.896-14.573l-15.777-27.332c29.345-15.27,62.293-24.37,97.215-25.951 v31.46c0,5.896,4.771,10.667,10.667,10.667s10.667-4.771,10.667-10.667v-31.46c34.922,1.581,67.87,10.681,97.215,25.951 l-15.777,27.332c-2.958,5.104-1.208,11.625,3.896,14.573c1.688,0.969,3.521,1.427,5.333,1.427c3.667,0,7.271-1.917,9.229-5.333 l15.746-27.28c28.54,18.322,52.819,42.599,71.142,71.138l-27.263,15.746c-5.104,2.948-6.854,9.469-3.896,14.573 c1.958,3.427,5.563,5.333,9.229,5.333c1.812,0,3.646-0.458,5.333-1.427l27.324-15.781c15.268,29.344,24.367,62.289,25.948,97.208 h-31.46c-5.896,0-10.667,4.771-10.667,10.667C448,347.229,452.771,352,458.667,352z"/></g></g></g></svg>
            <span class="mx-3">Dashboard</span>
        </a>
    </li>

    <!-- <li class="px-2 py-2 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'feeds' ? 'active':'' }}">
        <a href="{{ url('/accountant/feeds') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="460pt" viewBox="-11 0 460 460.11908" width="460pt" xmlns="http://www.w3.org/2000/svg"><path d="m204.636719 0h-3.378907c-13.730468 0-25.351562 11.054688-25.351562 24.785156v23.875l-72.027344-20.976562c-2.023437-.589844-4.199218-.347656-6.039062.675781-1.84375 1.027344-3.195313 2.746094-3.761719 4.777344l-93.714844 322.976562c-1.203125 4.253907 1.25 8.683594 5.496094 9.914063l322.988281 93.773437c4.226563 1.230469 8.65625-1.183593 9.917969-5.402343l10-34.398438h80.941406c4.476563-.03125 8.113281-3.625 8.199219-8.101562v-336.316407c0-4.417969-3.78125-7.582031-8.199219-7.582031h-188.175781l-11.625-3.898438v-39.316406c0-13.730468-11.539062-24.785156-25.269531-24.785156zm-12.730469 24.785156c0-4.90625 4.441406-8.785156 9.351562-8.785156h3.378907c4.910156 0 9.269531 3.878906 9.269531 8.785156v34.667969l-22-6.148437zm161.507812 379.214844 68.492188-235.332031v235.332031zm68.492188-320v35.890625l-125.265625-35.890625zm-6.78125 50.589844-89.402344 307.609375-307.660156-89.304688 89.46875-307.617187 106.375 30.835937v54.585938c0 4.972656-4.03125 9-9 9-4.972656 0-9-4.027344-9-9v-33.238281c0-4.417969-3.582031-8-8-8s-8 3.582031-8 8v33.238281c0 13.808593 11.191406 25 25 25 13.804688 0 25-11.191407 25-25v-49.9375zm0 0"/></svg>
            <span class="mx-3 whitespace-no-wrap">Feed</span>
        </a>
    </li> --> <!-- have to enable when feed added in all login -->

    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'events' ? 'active':'' }}">
        <a href="{{ url('accountant/events') }}" class="flex items-center">
            <!-- <img src="{{asset('uploads/icons/sidebar/calendar.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5 fill-current text-white" height="512" viewBox="0 0 128 128" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m121.693 14.088h-22.429v-7.781a1.75 1.75 0 0 0 -1.75-1.75h-7.462a1.749 1.749 0 0 0 -1.75 1.75v7.781h-18.821v-7.781a1.749 1.749 0 0 0 -1.75-1.75h-7.462a1.749 1.749 0 0 0 -1.75 1.75v7.781h-18.819v-7.781a1.749 1.749 0 0 0 -1.75-1.75h-7.464a1.75 1.75 0 0 0 -1.75 1.75v7.781h-22.429a1.749 1.749 0 0 0 -1.75 1.75v105.855a1.749 1.749 0 0 0 1.75 1.75h115.386a1.749 1.749 0 0 0 1.75-1.75v-105.855a1.749 1.749 0 0 0 -1.75-1.75zm-29.893-6.031h3.962v15.562h-3.962zm-29.783 0h3.962v15.562h-3.96zm-29.783 0h3.966v15.562h-3.964zm-24.177 9.531h20.679v7.781a1.75 1.75 0 0 0 1.75 1.75h7.462a1.749 1.749 0 0 0 1.75-1.75v-7.781h18.821v7.781a1.749 1.749 0 0 0 1.75 1.75h7.462a1.749 1.749 0 0 0 1.75-1.75v-7.781h18.819v7.781a1.749 1.749 0 0 0 1.75 1.75h7.462a1.75 1.75 0 0 0 1.75-1.75v-7.781h20.679v20.025h-111.884zm0 102.355v-78.83h111.886v78.83z"/><path d="m27.66 49.015a8.033 8.033 0 1 0 8.033 8.033 8.041 8.041 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.537 4.537 0 0 1 -4.533 4.533z"/><path d="m51.887 49.015a8.033 8.033 0 1 0 8.033 8.033 8.042 8.042 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.538 4.538 0 0 1 -4.533 4.533z"/><path d="m76.113 49.015a8.033 8.033 0 1 0 8.033 8.033 8.042 8.042 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.537 4.537 0 0 1 -4.533 4.533z"/><path d="m100.34 49.015a8.033 8.033 0 1 0 8.032 8.033 8.041 8.041 0 0 0 -8.032-8.033zm0 12.566a4.533 4.533 0 1 1 4.532-4.533 4.537 4.537 0 0 1 -4.532 4.533z"/><path d="m27.66 72.5a8.034 8.034 0 1 0 8.033 8.033 8.042 8.042 0 0 0 -8.033-8.033zm0 12.567a4.534 4.534 0 1 1 4.533-4.534 4.538 4.538 0 0 1 -4.533 4.529z"/><path d="m51.887 72.5a8.034 8.034 0 1 0 8.033 8.033 8.043 8.043 0 0 0 -8.033-8.033zm0 12.567a4.534 4.534 0 1 1 4.533-4.534 4.539 4.539 0 0 1 -4.533 4.529z"/><path d="m76.113 72.5a8.034 8.034 0 1 0 8.033 8.033 8.043 8.043 0 0 0 -8.033-8.033zm0 12.567a4.534 4.534 0 1 1 4.533-4.534 4.538 4.538 0 0 1 -4.533 4.529z"/><path d="m100.34 72.5a8.034 8.034 0 1 0 8.032 8.033 8.042 8.042 0 0 0 -8.032-8.033zm0 12.567a4.534 4.534 0 1 1 4.532-4.534 4.538 4.538 0 0 1 -4.532 4.529z"/><path d="m27.66 95.976a8.033 8.033 0 1 0 8.033 8.033 8.041 8.041 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.537 4.537 0 0 1 -4.533 4.533z"/><path d="m51.887 95.976a8.033 8.033 0 1 0 8.033 8.033 8.042 8.042 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.538 4.538 0 0 1 -4.533 4.533z"/><path d="m76.113 95.976a8.033 8.033 0 1 0 8.033 8.033 8.042 8.042 0 0 0 -8.033-8.033zm0 12.566a4.533 4.533 0 1 1 4.533-4.533 4.537 4.537 0 0 1 -4.533 4.533z"/><path d="m100.34 95.976a8.033 8.033 0 1 0 8.032 8.033 8.041 8.041 0 0 0 -8.032-8.033zm0 12.566a4.533 4.533 0 1 1 4.532-4.533 4.537 4.537 0 0 1 -4.532 4.533z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">Calendar</span>
        </a>
    </li>
@if(config('gfee.enabled', false))
    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'fees' ? 'active':'' }} || {{ Request::segment ('2') == 'fee' ? 'active':'' }}">
        <a href="{{ url('/accountant/fees') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" height="512pt" viewBox="-2 0 512 512.00005" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m314.652344 294.195312c13.75-17.015624 12.722656-42.089843-3.085938-57.902343-16.910156-16.910157-44.421875-16.914063-61.332031-.007813l-14.496094 14.496094c-5.320312 5.324219-13.984375 5.320312-19.3125-.003906-2.582031-2.582032-4-6.011719-4.003906-9.660156 0-3.644532 1.421875-7.074219 3.996094-9.652344l24.527343-24.527344c5.804688-5.800781 5.804688-15.207031 0-21.007812-5.800781-5.804688-15.207031-5.804688-21.007812 0l-6.773438 6.773437-6.464843-6.464844c-5.800781-5.800781-15.207031-5.800781-21.011719 0-5.800781 5.804688-5.800781 15.207031 0 21.011719l6.640625 6.636719c-6.230469 7.691406-9.617187 17.203125-9.617187 27.238281 0 11.582031 4.515624 22.472656 12.707031 30.664062 8.453125 8.457032 19.5625 12.683594 30.667969 12.683594 11.105468 0 22.210937-4.226562 30.660156-12.675781l14.496094-14.496094c5.324218-5.324219 13.988281-5.320312 19.316406.003907 5.324218 5.328124 5.328125 13.992187.003906 19.3125l-28.445312 28.445312c-5.804688 5.800781-5.804688 15.207031 0 21.007812 2.898437 2.902344 6.699218 4.355469 10.503906 4.351563 3.800781 0 7.605468-1.449219 10.503906-4.351563l10.695312-10.691406 6.464844 6.460938c2.902344 2.902344 6.703125 4.351562 10.503906 4.351562 3.804688 0 7.605469-1.449218 10.507813-4.351562 5.800781-5.800782 5.800781-15.207032 0-21.007813zm0 0"/><path d="m350.742188 94.394531c-8.417969 8.417969-13.054688 19.609375-13.054688 31.511719 0 11.90625 4.636719 23.097656 13.054688 31.515625 8.6875 8.6875 20.101562 13.03125 31.515624 13.03125 11.414063 0 22.824219-4.34375 31.511719-13.03125 17.378907-17.378906 17.378907-45.652344 0-63.03125-17.375-17.375-45.652343-17.371094-63.027343.003906zm42.019531 42.019531c-5.792969 5.792969-15.21875 5.789063-21.011719 0-5.789062-5.792968-5.789062-15.21875 0-21.011718 5.792969-5.789063 15.21875-5.789063 21.011719 0 5.792969 5.792968 5.792969 15.21875 0 21.011718zm0 0"/><path d="m500.917969 20.582031c-.234375-7.855469-6.542969-14.167969-14.394531-14.40625l-202.539063-6.1679685c-4.132813-.1171875-8.109375 1.4648435-11.007813 4.3945315l-250 252.574218c-30.636718 30.953126-30.636718 81.316407 0 112.265626l118.214844 119.429687c14.886719 15.042969 34.695313 23.328125 55.773438 23.328125 21.074218 0 40.882812-8.285156 55.773437-23.328125l249.996094-252.574219c2.863281-2.890625 4.414063-6.828125 4.289063-10.894531zm-269.296875 447.1875c-9.265625 9.363281-21.574219 14.519531-34.65625 14.519531-13.085938 0-25.394532-5.15625-34.660156-14.519531l-118.210938-119.429687c-19.230469-19.425782-19.230469-51.035156 0-70.460938l245.449219-247.976562 182.09375 5.546875 5.5 184.277343zm0 0"/></svg>
            <span class="mx-3">Fee Details</span>
        </a>
    </li>
@endif
    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'holidays' ? 'active':'' }} && {{ Request::segment ('2') == 'holiday' ? 'active':'' }}">
        <a href="{{ url('accountant/holidays') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g id="XMLID_2374_"><g id="XMLID_707_"><g id="XMLID_708_"><path id="XMLID_713_" d="m482 108h-14v-14c0-16.542-13.458-30-30-30h-24v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-84v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-84v-12c0-17.645-14.355-32-32-32s-32 14.355-32 32v12h-24c-16.542 0-30 13.458-30 30v324c0 16.542 13.458 30 30 30h14v14c0 16.542 13.458 30 30 30h408c16.542 0 30-13.458 30-30v-324c0-16.542-13.458-30-30-30zm-112-56c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-148 0c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-148 0c0-6.617 5.383-12 12-12s12 5.383 12 12v44c0 6.617-5.383 12-12 12s-12-5.383-12-12zm-44 32h24v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h84v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h84v12c0 17.645 14.355 32 32 32s32-14.355 32-32v-12h24c5.514 0 10 4.486 10 10v90h-428v-90c0-5.514 4.486-10 10-10zm462 378c0 5.514-4.486 10-10 10h-408c-5.514 0-10-4.486-10-10v-14h125c5.523 0 10-4.478 10-10s-4.477-10-10-10h-159c-5.514 0-10-4.486-10-10v-214h428v214c0 5.514-4.486 10-10 10h-159c-5.523 0-10 4.478-10 10s4.477 10 10 10h159c16.542 0 30-13.458 30-30v-290h14c5.514 0 10 4.486 10 10z"/><path id="XMLID_710_" d="m271.214 389.279c1.463.769 3.06 1.148 4.652 1.148 2.073 0 4.137-.645 5.879-1.91 3.08-2.237 4.622-6.028 3.978-9.78l-7.107-41.439 30.107-29.347c2.726-2.657 3.707-6.631 2.531-10.251s-4.306-6.259-8.073-6.807l-41.607-6.045-18.607-37.703c-1.685-3.413-5.161-5.574-8.967-5.574-3.807 0-7.283 2.161-8.967 5.574l-18.607 37.703-41.607 6.045c-3.767.548-6.896 3.187-8.073 6.807-1.176 3.62-.195 7.594 2.531 10.251l30.107 29.347-7.107 41.439c-.644 3.752.898 7.543 3.978 9.78s7.163 2.532 10.531.762l37.214-19.565zm-65.8-27.132 4.571-26.65c.557-3.244-.519-6.554-2.876-8.851l-19.362-18.873 26.758-3.888c3.257-.474 6.073-2.52 7.529-5.471l11.966-24.246 11.966 24.247c1.457 2.951 4.272 4.997 7.529 5.471l26.758 3.888-19.362 18.873c-2.357 2.298-3.433 5.607-2.876 8.851l4.571 26.65-23.933-12.583c-1.456-.766-3.055-1.149-4.653-1.149-1.599 0-3.197.383-4.653 1.149z"/><path id="XMLID_709_" d="m234 428c-2.63 0-5.21 1.069-7.07 2.93-1.86 1.86-2.93 4.44-2.93 7.07s1.07 5.21 2.93 7.069c1.86 1.86 4.44 2.931 7.07 2.931s5.21-1.07 7.07-2.931c1.86-1.859 2.93-4.439 2.93-7.069s-1.07-5.21-2.93-7.07c-1.86-1.861-4.44-2.93-7.07-2.93z"/></g></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Holiday</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'notices' ? 'active':'' }}" >
        <a href="{{ url('/accountant/notices') }}" class="flex items-center">
            <!--  <img src="{{asset('uploads/icons/sidebar/noticeboard.svg')}}" class="w-5 h-5"> -->
            <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" id="Layer_3" enable-background="new 0 0 64 64" height="512px" viewBox="0 0 64 64" width="512px"><g><path d="m21 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m35 33c-.553 0-1 .447-1 1v8c0 .553.447 1 1 1h8c.553 0 1-.447 1-1v-8c0-.553-.447-1-1-1zm2.586 5-1.586 1.586v-3.172zm-.172-3h3.172l-1.586 1.586zm1.586 4.414 1.586 1.586h-3.172zm1.414-1.414 1.586-1.586v3.172z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 51h26c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1zm1-4h24v2h-24z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 53h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m18 57h28v2h-28z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m62 9c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-12v-1c0-.553-.447-1-1-1h-34c-.553 0-1 .447-1 1v1h-12c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h1v46h-1c-.553 0-1 .447-1 1v4c0 .553.447 1 1 1h12v1c0 .553.447 1 1 1h34c.553 0 1-.447 1-1v-1h12c.553 0 1-.447 1-1v-4c0-.553-.447-1-1-1h-1v-46zm-59-4h11v2h-11zm11 4v46h-5v-46zm-9 0h2v46h-2zm-2 50v-2h11v2zm45 2h-32v-58h32zm13-56v2h-11v-2zm-11 50v-46h5v46zm11 4h-11v-2h11zm-2-4h-2v-46h2z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/><path d="m19 31h26c.553 0 1-.447 1-1v-24c0-.553-.447-1-1-1h-26c-.553 0-1 .447-1 1v24c0 .553.447 1 1 1zm10-17c0-1.654 1.346-3 3-3s3 1.346 3 3-1.346 3-3 3-3-1.346-3-3zm8 15h-10v-5c0-2.757 2.243-5 5-5s5 2.243 5 5zm-17-22h24v22h-5v-5c0-2.698-1.537-5.04-3.779-6.208 1.079-.918 1.779-2.268 1.779-3.792 0-2.757-2.243-5-5-5s-5 2.243-5 5c0 1.524.7 2.874 1.779 3.792-2.242 1.168-3.779 3.51-3.779 6.208v5h-5z" data-original="#000000" class="active-path" data-old_color="#000000" fill="#FFFFFF"/></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Notice Board</span>
        </a>
    </li>

    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'task' ? 'active':'' }}">
        <a href="{{ url('/accountant/task/add') }}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m60 512h272c33.084 0 60-26.916 60-60v-407c0-8.284-6.716-15-15-15h-75v-15c0-8.284-6.716-15-15-15h-121c-8.284 0-15 6.716-15 15v15h-75c-8.284 0-15 6.716-15 15v377h-46c-8.284 0-15 6.716-15 15v15c0 33.084 26.916 60 60 60zm121-482h91v30h-91zm-90 30h60v15c0 8.284 6.716 15 15 15h121c8.284 0 15-6.716 15-15v-15h60v392c0 16.542-13.458 30-30 30s-30-13.458-30-30v-15c0-8.284-6.716-15-15-15h-196zm181 392c0 10.92 2.934 21.17 8.052 30h-220.052c-16.542 0-30-13.458-30-30z"/><path d="m467 61c-24.813 0-45 20.187-45 45v270c0 1.588.324 3.407.754 4.696l30 91c2.027 6.15 7.771 10.304 14.246 10.304s12.219-4.154 14.246-10.304l30-91c.424-1.273.754-3.073.754-4.696v-270c0-24.813-20.187-45-45-45zm-15 300v-210h30v210zm15-270c8.271 0 15 6.729 15 15v15h-30v-15c0-8.271 6.729-15 15-15zm-9.261 300h18.521l-9.26 28.091z"/><path d="m226 181h91c8.284 0 15-6.716 15-15s-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15z"/><path d="m317 241h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15s-6.716-15-15-15z"/><path d="m332 346c0-8.284-6.716-15-15-15h-91c-8.284 0-15 6.716-15 15s6.716 15 15 15h91c8.284 0 15-6.716 15-15z"/><path d="m155.394 176.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m155.394 266.606c2.928 2.93 6.767 4.394 10.606 4.394s7.678-1.464 10.606-4.394l30-30c5.858-5.858 5.858-15.355 0-21.213-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.394-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213z"/><path d="m206.606 305.394c-5.857-5.858-15.355-5.858-21.213 0l-19.393 19.393-19.394-19.393c-5.857-5.858-15.355-5.858-21.213 0s-5.858 15.355 0 21.213l30 30c2.929 2.929 6.768 4.393 10.607 4.393s7.678-1.464 10.606-4.394l30-30c5.859-5.857 5.859-15.355 0-21.212z"/></g></svg>
            <span class="mx-3 whitespace-no-wrap">To Do List</span>
        </a>
    </li>

    <!-- payroll start -->
    <!-- @php
        $class='';
        $array=array('template','templates','payslip','payslips');
        if(in_array(\Request()->segment('3'),$array))
        {
            $class='active';
        }
    @endphp
    <li class="relative py-3 px-3 hover:font-semibold bg-light-green-900 {{ $class }}">
        <a href="#" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" id="_x33_0" enable-background="new 0 0 64 64" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m26.998 9h-3.996c-2.758 0-5.002 2.244-5.002 5.002 0 .815.202 1.627.585 2.349l1.94 3.649h1.029c-.343-.59-.554-1.268-.554-2v-.764c0-.758.428-1.45 1.106-1.789l2.894-1.447 2.894 1.447c.678.339 1.106 1.032 1.106 1.789v.764c0 .732-.211 1.41-.555 2h1.029l1.941-3.65c.383-.721.585-1.533.585-2.348 0-2.758-2.244-5.002-5.002-5.002z" fill=""/></g><g><g><path d="m48 15h-14v-6h14z" fill=""/></g></g><g><path d="m34 17h14v5h-14z" fill=""/></g><g><path d="m16 36h18v4h-18z" fill=""/></g><g><path d="m44 27.101v-2.101h-2v2h-4v5c0 2.757 2.243 5 5 5 1.654 0 3 1.346 3 3v3h-3c-1.654 0-3-1.346-3-3v-3h-2v3c0 2.414 1.721 4.434 4 4.899v2.101h2v-2h4v-5c0-2.757-2.243-5-5-5-1.654 0-3-1.346-3-3v-3h3c1.654 0 3 1.346 3 3v3h2v-3c0-2.414-1.721-4.434-4-4.899z"/><path d="m36 53h-8c-1.103 0-2 .897-2 2v2c0 1.103.897 2 2 2h8c1.103 0 2-.897 2-2v-2c0-1.103-.897-2-2-2zm-8 4v-2h8l.002 2z"/><path d="m49 1h-34c-3.859 0-7 3.141-7 7v48c0 3.859 3.141 7 7 7h34c3.859 0 7-3.141 7-7v-48c0-3.859-3.141-7-7-7zm5 55c0 2.757-2.243 5-5 5h-34c-2.757 0-5-2.243-5-5v-48c0-2.757 2.243-5 5-5h34c2.757 0 5 2.243 5 5z"/><path d="m49 5h-34c-1.654 0-3 1.346-3 3v40c0 1.654 1.346 3 3 3h34c1.654 0 3-1.346 3-3v-40c0-1.654-1.346-3-3-3zm1 43c0 .552-.448 1-1 1h-34c-.552 0-1-.448-1-1v-40c0-.552.448-1 1-1h34c.552 0 1 .448 1 1z"/><path d="m28.377 21.663c.991-.914 1.623-2.212 1.623-3.663v-.764c0-1.144-.636-2.172-1.658-2.684l-2.342-1.17v-4.382h-2v4.382l-2.342 1.171c-1.022.511-1.658 1.54-1.658 2.683v.764c0 1.451.632 2.749 1.623 3.663-3.293 1.339-5.623 4.569-5.623 8.337v1h18v-1c0-3.768-2.33-6.998-5.623-8.337zm-6.377-3.663v-.764c0-.382.212-.725.553-.895l2.447-1.223 2.447 1.224c.341.17.553.512.553.894v.764c0 1.654-1.346 3-3 3s-3-1.346-3-3zm4.971 5.285c-.14.967-.966 1.715-1.971 1.715s-1.831-.748-1.971-1.715c.626-.184 1.286-.285 1.971-.285s1.345.101 1.971.285zm-8.9 5.715c.292-2.033 1.465-3.782 3.114-4.859.495 1.647 2.008 2.859 3.815 2.859s3.32-1.212 3.814-2.859c1.649 1.078 2.823 2.826 3.114 4.859z"/><path d="m38 9h2v6h-2z"/><path d="m42 9h2v6h-2z"/><path d="m34 17h6v2h-6z"/><path d="m42 17h6v2h-6z"/><path d="m34 21h14v2h-14z"/><path d="m16 45h2v2h-2z"/><path d="m20 45h2v2h-2z"/><path d="m24 45h2v2h-2z"/><path d="m28 45h2v2h-2z"/><path d="m16 39h18v2h-18z"/><path d="m16 35h18v2h-18z"/><path d="m32 45h2v2h-2z"/></g></g></svg>
            <span class="mx-3 whitespace-no-wrap">Payroll</span>
        </a>
        <ul class="list-reset sites-sidebar">
            <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('4') == 'templates' ? 'active':'' }} || {{ Request::segment ('3') == 'template' ? 'active':'' }}">
                <a href="{{ url('/accountant/payroll/template') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m397.691 43.717c-.124-.023-.248-.04-.373-.057-.112-.015-.223-.03-.336-.039-.151-.013-.302-.019-.453-.023-.066-.002-.13-.01-.195-.01h-280.667c-.066 0-.13.008-.196.01-.15.004-.3.01-.45.023-.116.01-.23.025-.344.04-3.515.473-6.084 3.272-6.46 6.584-.01.09-.015.182-.021.273-.012.163-.023.325-.025.487 0 .028-.004.055-.004.083.333 131.096-.989 129.379 1.247 132.763 1.336 2.016 3.675 3.365 6.258 3.365.012 0 .025-.002.037-.002h280.583c.012 0 .025.002.037.002.028 0 .055-.006.083-.006 4.097-.043 7.377-3.366 7.418-7.417 0-.027.004-.053.004-.079v-128.626c0-.027-.004-.053-.004-.079-.035-3.583-2.627-6.649-6.139-7.292zm-35.726 14.871-105.965 48.563-105.966-48.563zm-238.798 4.187 114.832 52.626-114.832 52.626zm26.866 109.44 105.967-48.563 105.966 48.563zm238.8-4.187-114.831-52.626 114.831-52.626z"/><path d="m431 0h-350c-12.407 0-22.5 10.093-22.5 22.5v128.795c0 4.142 3.358 7.5 7.5 7.5s7.5-3.358 7.5-7.5v-128.795c0-4.136 3.364-7.5 7.5-7.5h350c4.136 0 7.5 3.364 7.5 7.5v467c0 4.136-3.364 7.5-7.5 7.5h-350c-4.136 0-7.5-3.364-7.5-7.5v-308.205c0-4.142-3.358-7.5-7.5-7.5s-7.5 3.358-7.5 7.5v308.205c0 12.407 10.093 22.5 22.5 22.5h350c12.406 0 22.5-10.093 22.5-22.5v-467c0-12.407-10.094-22.5-22.5-22.5z"/><path d="m108.167 309.93c0 4.142 3.358 7.5 7.5 7.5h108.697c4.142 0 7.5-3.358 7.5-7.5v-82.477c0-4.142-3.358-7.5-7.5-7.5h-108.697c-4.142 0-7.5 3.358-7.5 7.5zm15-74.977h93.697v67.477h-93.697z"/><path d="m397.17 219.953h-107.007c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h107.007c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5z"/><path d="m397.17 261.191h-107.007c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h107.007c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5z"/><path d="m397.17 302.43h-107.007c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h107.007c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5z"/><path d="m397.17 366.785h-108.696c-4.143 0-7.5 3.358-7.5 7.5v82.477c0 4.142 3.357 7.5 7.5 7.5h108.696c4.143 0 7.5-3.358 7.5-7.5v-82.477c0-4.142-3.357-7.5-7.5-7.5zm-7.5 82.477h-93.696v-67.477h93.696z"/><path d="m115.667 381.785h107.007c4.142 0 7.5-3.358 7.5-7.5s-3.358-7.5-7.5-7.5h-107.007c-4.142 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5z"/><path d="m115.667 423.023h107.007c4.142 0 7.5-3.358 7.5-7.5s-3.358-7.5-7.5-7.5h-107.007c-4.142 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5z"/><path d="m115.667 464.262h107.007c4.142 0 7.5-3.358 7.5-7.5s-3.358-7.5-7.5-7.5h-107.007c-4.142 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5z"/></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Template</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('3') == 'salary' ? 'active':'' }} || {{ Request::segment ('4') == 'salary' ? 'active':'' }}">
                <a href="{{ url('/accountant/payroll/salary') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" id="Capa_1" enable-background="new 0 0 512.066 512.066" height="512" viewBox="0 0 512.066 512.066" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m511.716 500.119c.488-2.285.323 11.703.323-308.092 0-4.041-1.675-8.102-4.8-10.999.281 0-3.638-2.785-76.2-55.494v-48.508c0-24.813-20.187-45-45-45h-20.922c-5.592-18.494-22.784-32-43.078-32h-196c-24.813 0-45 20.187-45 45v80.509c-80.717 58.659-75.702 54.727-77.477 56.841-1.47 1.752-2.574 3.881-3.125 6.251-.619 2.654-.397-15.777-.397 308.367-.022 7.398 5.442 13.899 13.058 14.896 1.618.212 485.068.137 483.944.137 7.015-.001 13.211-4.927 14.674-11.908zm-481.677-278.576 167.907 122.538-167.907 123.317zm226 117.095c8.999 6.609 186.407 136.904 195.236 143.389h-390.472c8.823-6.481 186.237-136.78 195.236-143.389zm226-117.095v245.855l-167.908-123.317zm-10.48-29.491-40.52 29.572v-59.011c11.129 8.085 24.362 17.697 40.52 29.439zm-70.52-115.026v166.491l-34 24.813v-206.304h19c8.271 0 15 6.729 15 15zm-275-47h196c8.271 0 15 6.729 15 15v245.198l-48.272 35.229-14.969-10.994c-10.621-7.803-24.896-7.803-35.518 0 .1-.1-1.2.881-14.97 10.994l-112.271-81.936v-198.491c0-8.271 6.728-15 15-15zm-45 132.589v59.008l-40.521-29.572c24.137-17.539 35.614-25.871 40.521-29.436z"/></g><g><path d="m240.692 157.655c-7.474-2.644-19.662-7.085-25.769-11.874-.37-.291-1.062-2.032-.576-4.619.234-1.242 1.308-5.388 5.332-6.601 6.214-1.883 12.112-.646 15.982 2.22 6.109 5.563 15.57 5.14 21.156-.956 5.579-6.089 5.182-15.535-.872-21.139 0 0-6.95-6.188-16.888-9.116v-1.234c0-8.284-6.716-15-15-15s-15 6.716-15 15v2.17c-26.962 9.806-33.302 46.688-12.646 62.884 9.41 7.378 22.857 12.507 34.272 16.547 7.436 2.63 8.191 7.962 7.517 11.973-.751 4.463-4.596 12.034-14.244 12.097-10.002.064-12.375-.303-19.675-5.081-6.933-4.536-16.228-2.597-20.766 4.336-4.537 6.932-2.596 16.229 4.336 20.766 7.974 5.219 14.29 7.805 21.205 9.016v1.443c0 8.284 6.716 15 15 15s15-6.716 15-15v-3.139c36.343-13.135 41.165-65.71 1.636-79.693z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Salary</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('3') == 'payslip' ? 'active':'' }} || {{ Request::segment ('4') == 'payslip' ? 'active':'' }}">
                <a href="{{ url('/accountant/payroll/payslip') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" id="_x33_0" enable-background="new 0 0 64 64" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><g><g><path d="m26.998 9h-3.996c-2.758 0-5.002 2.244-5.002 5.002 0 .815.202 1.627.585 2.349l1.94 3.649h1.029c-.343-.59-.554-1.268-.554-2v-.764c0-.758.428-1.45 1.106-1.789l2.894-1.447 2.894 1.447c.678.339 1.106 1.032 1.106 1.789v.764c0 .732-.211 1.41-.555 2h1.029l1.941-3.65c.383-.721.585-1.533.585-2.348 0-2.758-2.244-5.002-5.002-5.002z" fill=""/></g><g><g><path d="m48 15h-14v-6h14z" fill=""/></g></g><g><path d="m34 17h14v5h-14z" fill=""/></g><g><path d="m16 36h18v4h-18z" fill=""/></g><g><path d="m44 27.101v-2.101h-2v2h-4v5c0 2.757 2.243 5 5 5 1.654 0 3 1.346 3 3v3h-3c-1.654 0-3-1.346-3-3v-3h-2v3c0 2.414 1.721 4.434 4 4.899v2.101h2v-2h4v-5c0-2.757-2.243-5-5-5-1.654 0-3-1.346-3-3v-3h3c1.654 0 3 1.346 3 3v3h2v-3c0-2.414-1.721-4.434-4-4.899z"/><path d="m36 53h-8c-1.103 0-2 .897-2 2v2c0 1.103.897 2 2 2h8c1.103 0 2-.897 2-2v-2c0-1.103-.897-2-2-2zm-8 4v-2h8l.002 2z"/><path d="m49 1h-34c-3.859 0-7 3.141-7 7v48c0 3.859 3.141 7 7 7h34c3.859 0 7-3.141 7-7v-48c0-3.859-3.141-7-7-7zm5 55c0 2.757-2.243 5-5 5h-34c-2.757 0-5-2.243-5-5v-48c0-2.757 2.243-5 5-5h34c2.757 0 5 2.243 5 5z"/><path d="m49 5h-34c-1.654 0-3 1.346-3 3v40c0 1.654 1.346 3 3 3h34c1.654 0 3-1.346 3-3v-40c0-1.654-1.346-3-3-3zm1 43c0 .552-.448 1-1 1h-34c-.552 0-1-.448-1-1v-40c0-.552.448-1 1-1h34c.552 0 1 .448 1 1z"/><path d="m28.377 21.663c.991-.914 1.623-2.212 1.623-3.663v-.764c0-1.144-.636-2.172-1.658-2.684l-2.342-1.17v-4.382h-2v4.382l-2.342 1.171c-1.022.511-1.658 1.54-1.658 2.683v.764c0 1.451.632 2.749 1.623 3.663-3.293 1.339-5.623 4.569-5.623 8.337v1h18v-1c0-3.768-2.33-6.998-5.623-8.337zm-6.377-3.663v-.764c0-.382.212-.725.553-.895l2.447-1.223 2.447 1.224c.341.17.553.512.553.894v.764c0 1.654-1.346 3-3 3s-3-1.346-3-3zm4.971 5.285c-.14.967-.966 1.715-1.971 1.715s-1.831-.748-1.971-1.715c.626-.184 1.286-.285 1.971-.285s1.345.101 1.971.285zm-8.9 5.715c.292-2.033 1.465-3.782 3.114-4.859.495 1.647 2.008 2.859 3.815 2.859s3.32-1.212 3.814-2.859c1.649 1.078 2.823 2.826 3.114 4.859z"/><path d="m38 9h2v6h-2z"/><path d="m42 9h2v6h-2z"/><path d="m34 17h6v2h-6z"/><path d="m42 17h6v2h-6z"/><path d="m34 21h14v2h-14z"/><path d="m16 45h2v2h-2z"/><path d="m20 45h2v2h-2z"/><path d="m24 45h2v2h-2z"/><path d="m28 45h2v2h-2z"/><path d="m16 39h18v2h-18z"/><path d="m16 35h18v2h-18z"/><path d="m32 45h2v2h-2z"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Payroll</span>
                </a>
            </li>
            <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('3') == 'transaction' ? 'active':'' }} || {{ Request::segment ('4') == 'transaction' ? 'active':'' }} ">
                <a href="{{ url('/accountant/payroll/transaction') }}" class="flex items-center">
                    <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 496 496" style="enable-background:new 0 0 496 496;" xml:space="preserve"><g><g><path d="M392,144c-57.344,0-104,46.656-104,104s46.656,104,104,104s104-46.656,104-104S449.344,144,392,144z M392,336 c-48.52,0-88-39.48-88-88c0-48.52,39.48-88,88-88c48.52,0,88,39.48,88,88S440.52,336,392,336z"/></g></g><g><g><path d="M392,240c-8.824,0-16-7.176-16-16c0-8.824,7.176-16,16-16c8.824,0,16,7.176,16,16h16c0-14.864-10.24-27.288-24-30.864V176 h-16v17.136c-13.76,3.576-24,16-24,30.864c0,17.648,14.352,32,32,32c8.824,0,16,7.176,16,16c0,8.824-7.176,16-16,16 c-8.824,0-16-7.176-16-16h-16c0,14.872,10.24,27.288,24,30.864V320h16v-17.136c13.76-3.576,24-15.992,24-30.864 C424,254.352,409.648,240,392,240z"/></g></g><g><g><path d="M191.848,315.008L144,305.44v-11.552c8.008-5.6,14.456-13.24,18.648-22.16C179.04,270.36,192,256.744,192,240v-40 c0-44.112-35.888-80-80-80s-80,35.888-80,80v40c0,16.744,12.96,30.36,29.352,31.728c4.192,8.92,10.64,16.56,18.648,22.16v11.552 l-47.848,9.568C13.52,318.736,0,335.232,0,354.232V376h224v-21.768C224,335.232,210.48,318.728,191.848,315.008z M167.672,253.952 c0.208-1.96,0.328-3.944,0.328-5.952v-21.776c4.76,2.776,8,7.88,8,13.776C176,246.032,172.608,251.224,167.672,253.952z M48,240 c0-5.896,3.24-11,8-13.776V248c0,2.008,0.12,3.992,0.328,5.952C51.392,251.224,48,246.032,48,240z M57.24,208.752 c-3.32,0.72-6.392,2.04-9.24,3.696V200c0-35.288,28.712-64,64-64s64,28.712,64,64v12.448c-2.848-1.664-5.92-2.984-9.24-3.704 C163.664,199.072,154.688,192,144,192H80C69.312,192,60.336,199.072,57.24,208.752z M72,248v-32c0-4.408,3.592-8,8-8h64 c4.408,0,8,3.592,8,8v32c0,22.056-17.944,40-40,40C89.944,288,72,270.056,72,248z M128,301.64v7.048l-16,16l-16-16v-7.048 c5.072,1.52,10.44,2.36,16,2.36S122.928,303.16,128,301.64z M208,360H16v-5.768c0-11.408,8.112-21.304,19.296-23.536l50.08-10.016 L112,347.312l26.632-26.632l50.08,10.016C199.888,332.928,208,342.832,208,354.232V360z"/></g></g><g><g><path d="M384,368v104c0,4.416-3.592,8-8,8H128c-4.408,0-8-3.584-8-8v-54.608l42.792,36.672l10.416-12.144L112,389.464 l-61.208,52.472l10.416,12.144L104,417.392V472c0,13.232,10.768,24,24,24h248c13.232,0,24-10.768,24-24V368H384z"/></g></g><g><g><path d="M442.792,65.92L400,102.608V24c0-13.232-10.768-24-24-24H128c-13.232,0-24,10.768-24,24v80h16V24c0-4.408,3.592-8,8-8h248 c4.408,0,8,3.592,8,8v78.608l-42.792-36.68L330.792,78.08L392,130.536l61.208-52.464L442.792,65.92z"/></g></g><g><g><rect x="440" y="240" width="16" height="16"/></g></g><g><g><rect x="328" y="240" width="16" height="16"/></g></g><g><g><rect x="272" y="32" width="16" height="16"/></g></g><g><g><rect x="240" y="32" width="16" height="16"/></g></g><g><g><rect x="208" y="32" width="16" height="16"/></g></g><g><g><rect x="272" y="448" width="16" height="16"/></g></g><g><g><rect x="240" y="448" width="16" height="16"/></g></g><g><g><rect x="208" y="448" width="16" height="16"/></g></g></svg>
                    <span class="mx-3 whitespace-no-wrap">Transaction</span>
                </a>
            </li>
        </ul>
    </li> -->
    <!-- payroll end -->  <!-- have to enable when payroll integrated-->

    <li class="py-3 px-3 hover:font-semibold bg-light-green-900 {{ Request::segment ('2') == 'activity' ? 'active':'' }}">
        <a href="{{ url('/accountant/activity' )}}" class="flex items-center">
            <svg class="w-5 h-5 fill-current text-white" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 479.984 479.984" style="enable-background:new 0 0 479.984 479.984;" xml:space="preserve"><g><g><g><path d="M56.066,96h280c4.418,0,8-3.582,8-8s-3.582-8-8-8h-280c-4.418,0-8,3.582-8,8S51.648,96,56.066,96z"/><path d="M56.066,160h280c4.418,0,8-3.582,8-8s-3.582-8-8-8h-280c-4.418,0-8,3.582-8,8S51.648,160,56.066,160z"/><path d="M56.066,224h280c4.418,0,8-3.582,8-8s-3.582-8-8-8h-280c-4.418,0-8,3.582-8,8S51.648,224,56.066,224z"/><path d="M440.066,282.464V8c0-4.418-3.582-8-8-8h-424c-4.418,0-8,3.582-8,8v424c0,4.418,3.582,8,8,8h274.4 c6.575,7.864,14.188,14.797,22.632,20.608c51.103,34.749,120.7,21.492,155.45-29.612 C492.807,383.556,483.96,319.404,440.066,282.464z M16.066,424V16h408v255.016c-2.432-1.408-4.915-2.723-7.448-3.944 l-0.672-0.296c-3.024-1.44-6.112-2.696-9.232-3.848c-0.864-0.32-1.728-0.632-2.6-0.928c-3.36-1.144-6.752-2.184-10.184-2.984 c-60.284-14.205-120.67,23.15-134.875,83.435c-1.973,8.374-2.976,16.946-2.989,25.549c0,2.88,0.136,5.744,0.352,8.584 c0.064,0.88,0.168,1.752,0.256,2.624c0.192,2,0.432,4,0.736,5.952c0.144,0.952,0.296,1.896,0.464,2.84 c0.36,2.024,0.8,4,1.264,6.024c0.176,0.76,0.336,1.536,0.528,2.288c0.704,2.72,1.496,5.408,2.4,8.056 c0.128,0.36,0.28,0.72,0.408,1.08c0.805,2.283,1.691,4.536,2.656,6.76c0.352,0.8,0.728,1.6,1.104,2.4 c0.8,1.792,1.696,3.576,2.624,5.328c0.432,0.8,0.864,1.6,1.32,2.448c0.296,0.528,0.56,1.072,0.864,1.6L16.066,424z M457.926,401.492c-13.977,37.544-49.798,62.462-89.86,62.508h0c-19.25,0.044-38.063-5.744-53.96-16.6 c-8.222-5.633-15.531-12.494-21.672-20.344c-17.052-21.741-23.859-49.798-18.664-76.936c9.875-52.092,60.108-86.315,112.2-76.441 c1.433,0.272,2.861,0.576,4.28,0.913c3.803,0.906,7.544,2.055,11.2,3.44C451.138,296.529,476.423,351.805,457.926,401.492z"/><path d="M432.066,352c4.418,0,8-3.582,8-8s-3.582-8-8-8h-32v-32c0-4.418-3.582-8-8-8s-8,3.582-8,8v32h-32v-32 c0-4.418-3.582-8-8-8s-8,3.582-8,8v32h-32c-4.418,0-8,3.582-8,8s3.582,8,8,8h32v32h-32c-4.418,0-8,3.582-8,8s3.582,8,8,8h32v32 c0,4.418,3.582,8,8,8s8-3.582,8-8v-32h32v32c0,4.418,3.582,8,8,8s8-3.582,8-8v-32h32c4.418,0,8-3.582,8-8s-3.582-8-8-8h-32v-32 H432.066z M384.066,384h-32v-32h32V384z"/><path d="M264.066,280c0-4.418-3.582-8-8-8h-200c-4.418,0-8,3.582-8,8s3.582,8,8,8h200C260.485,288,264.066,284.418,264.066,280z"/></g></g></g> </svg>
            <span class="mx-3 whitespace-no-wrap">Activity Log</span>
        </a>
    </li>
</ul>