"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _lodash = _interopRequireDefault(require("lodash"));

var _flattenColorPalette = _interopRequireDefault(require("../util/flattenColorPalette"));

var _withAlphaVariable = _interopRequireDefault(require("../util/withAlphaVariable"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default() {
  return function ({
    addUtilities,
    e,
    theme,
    variants,
    target,
    corePlugins
  }) {
    if (target('textColor') === 'ie11') {
      const utilities = _lodash.default.fromPairs(_lodash.default.map((0, _flattenColorPalette.default)(theme('textColor')), (value, modifier) => {
        return [`.${e(`text-${modifier}`)}`, {
          color: value
        }];
      }));

      addUtilities(utilities, variants('textColor'));
      return;
    }

    const utilities = _lodash.default.fromPairs(_lodash.default.map((0, _flattenColorPalette.default)(theme('textColor')), (value, modifier) => {
      return [`.${e(`text-${modifier}`)}`, corePlugins('textOpacity') ? (0, _withAlphaVariable.default)({
        color: value,
        property: 'color',
        variable: '--text-opacity'
      }) : {
        color: value
      }];
    }));

    addUtilities(utilities, variants('textColor'));
  };
}