/*
    portal-vue
    Version: 1.5.1
    Licence: MIT
    (c) Thorsten Lünborg
  */
  
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('vue')) :
	typeof define === 'function' && define.amd ? define(['vue'], factory) :
	(global.PortalVue = factory(global.Vue));
}(this, (function (Vue) { 'use strict';

Vue = Vue && Vue.hasOwnProperty('default') ? Vue['default'] : Vue;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};





















var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};



































var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

function extractAttributes(el) {
  var map = el.hasAttributes() ? el.attributes : [];
  var attrs = {};
  for (var i = 0; i < map.length; i++) {
    var attr = map[i];
    if (attr.value) {
      attrs[attr.name] = attr.value === '' ? true : attr.value;
    }
  }
  var klass = void 0,
      style = void 0;
  if (attrs.class) {
    klass = attrs.class;
    delete attrs.class;
  }
  if (attrs.style) {
    style = attrs.style;
    delete attrs.style;
  }
  var data = {
    attrs: attrs,
    class: klass,
    style: style
  };
  return data;
}

function freeze(item) {
  if (Array.isArray(item) || (typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object') {
    return Object.freeze(item);
  }
  return item;
}

function combinePassengers(transports) {
  var slotProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  return transports.reduce(function (passengers, transport) {
    var newPassengers = transport.passengers[0];
    newPassengers = typeof newPassengers === 'function' ? newPassengers(slotProps) : transport.passengers;
    return passengers.concat(newPassengers);
  }, []);
}

function stableSort(array, compareFn) {
  return array.map(function (v, idx) {
    return [idx, v];
  }).sort(function (a, b) {
    return this(a[1], b[1]) || a[0] - b[0];
  }.bind(compareFn)).map(function (c) {
    return c[1];
  });
}

var transports = {};

var Wormhole = Vue.extend({
  data: function data() {
    return { transports: transports };
  },
  methods: {
    open: function open(transport) {
      var to = transport.to,
          from = transport.from,
          passengers = transport.passengers;

      if (!to || !from || !passengers) return;

      transport.passengers = freeze(passengers);
      var keys = Object.keys(this.transports);
      if (keys.indexOf(to) === -1) {
        Vue.set(this.transports, to, []);
      }

      var currentIndex = this.getTransportIndex(transport);
      // Copying the array here so that the PortalTarget change event will actually contain two distinct arrays
      var newTransports = this.transports[to].slice(0);
      if (currentIndex === -1) {
        newTransports.push(transport);
      } else {
        newTransports[currentIndex] = transport;
      }
      this.transports[to] = stableSort(newTransports, function (a, b) {
        return a.order - b.order;
      });
    },
    close: function close(transport) {
      var force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var to = transport.to,
          from = transport.from;

      if (!to || !from) return;
      if (!this.transports[to]) {
        return;
      }

      if (force) {
        this.transports[to] = [];
      } else {
        var index = this.getTransportIndex(transport);
        if (index >= 0) {
          // Copying the array here so that the PortalTarget change event will actually contain two distinct arrays
          var newTransports = this.transports[to].slice(0);
          newTransports.splice(index, 1);
          this.transports[to] = newTransports;
        }
      }
    },
    hasTarget: function hasTarget(to) {
      return this.transports.hasOwnProperty(to);
    },
    hasContentFor: function hasContentFor(to) {
      if (!this.transports[to]) {
        return false;
      }
      return this.getContentFor(to).length > 0;
    },
    getSourceFor: function getSourceFor(to) {
      return this.transports[to] && this.transports[to][0].from;
    },
    getContentFor: function getContentFor(to) {
      var transports = this.transports[to];
      if (!transports) {
        return undefined;
      }
      return combinePassengers(transports);
    },
    getTransportIndex: function getTransportIndex(_ref) {
      var to = _ref.to,
          from = _ref.from;

      for (var i in this.transports[to]) {
        if (this.transports[to][i].from === from) {
          return i;
        }
      }
      return -1;
    }
  }
});

var wormhole = new Wormhole(transports);

var nestRE = /^(attrs|props|on|nativeOn|class|style|hook)$/;

var babelHelperVueJsxMergeProps = function mergeJSXProps (objs) {
  return objs.reduce(function (a, b) {
    var aa, bb, key, nestedKey, temp;
    for (key in b) {
      aa = a[key];
      bb = b[key];
      if (aa && nestRE.test(key)) {
        // normalize class
        if (key === 'class') {
          if (typeof aa === 'string') {
            temp = aa;
            a[key] = aa = {};
            aa[temp] = true;
          }
          if (typeof bb === 'string') {
            temp = bb;
            b[key] = bb = {};
            bb[temp] = true;
          }
        }
        if (key === 'on' || key === 'nativeOn' || key === 'hook') {
          // merge functions
          for (nestedKey in bb) {
            aa[nestedKey] = mergeFn(aa[nestedKey], bb[nestedKey]);
          }
        } else if (Array.isArray(aa)) {
          a[key] = aa.concat(bb);
        } else if (Array.isArray(bb)) {
          a[key] = [aa].concat(bb);
        } else {
          for (nestedKey in bb) {
            aa[nestedKey] = bb[nestedKey];
          }
        }
      } else {
        a[key] = b[key];
      }
    }
    return a
  }, {})
};

function mergeFn (a, b) {
  return function () {
    a && a.apply(this, arguments);
    b && b.apply(this, arguments);
  }
}

// import { transports } from './wormhole'
var PortalTarget = {
  abstract: false,
  name: 'portalTarget',
  props: {
    attributes: { type: Object, default: function _default() {
        return {};
      } },
    multiple: { type: Boolean, default: false },
    name: { type: String, required: true },
    slim: { type: Boolean, default: false },
    slotProps: { type: Object, default: function _default() {
        return {};
      } },
    tag: { type: String, default: 'div' },
    transition: { type: [Boolean, String, Object], default: false },
    transitionEvents: { type: Object, default: function _default() {
        return {};
      } }
  },
  data: function data() {
    return {
      transports: wormhole.transports,
      firstRender: true
    };
  },
  created: function created() {
    if (!this.transports[this.name]) {
      this.$set(this.transports, this.name, []);
    }
  },
  mounted: function mounted() {
    var _this = this;

    this.unwatch = this.$watch('ownTransports', this.emitChange);
    this.$nextTick(function () {
      if (_this.transition) {
        // only when we have a transition, because it causes a re-render
        _this.firstRender = false;
      }
    });
    if (this.$options.abstract) {
      this.$options.abstract = false;
    }
  },
  updated: function updated() {
    if (this.$options.abstract) {
      this.$options.abstract = false;
    }
  },
  beforeDestroy: function beforeDestroy() {
    this.unwatch();
  },


  computed: {
    ownTransports: function ownTransports() {
      var transports$$1 = this.transports[this.name] || [];
      if (this.multiple) {
        return transports$$1;
      }
      return transports$$1.length === 0 ? [] : [transports$$1[transports$$1.length - 1]];
    },
    passengers: function passengers() {
      return combinePassengers(this.ownTransports, this.slotProps);
    },
    hasAttributes: function hasAttributes() {
      return Object.keys(this.attributes).length > 0;
    },
    withTransition: function withTransition() {
      return !!this.transition;
    },
    transitionData: function transitionData() {
      var t = this.transition;
      var data = {};

      // During first render, we render a dumb transition without any classes, events and a fake name
      // We have to do this to emulate the normal behaviour of transitions without `appear`
      // because in Portals, transitions can behave as if appear was defined under certain conditions.
      if (this.firstRender && _typeof(this.transition) === 'object' && !this.transition.appear) {
        data.props = { name: '__notranstition__portal-vue__' };
        return data;
      }

      if (typeof t === 'string') {
        data.props = { name: t };
      } else if ((typeof t === 'undefined' ? 'undefined' : _typeof(t)) === 'object') {
        data.props = t;
      }
      if (this.renderSlim) {
        data.props.tag = this.tag;
      }
      data.on = this.transitionEvents;

      return data;
    },
    transportedClasses: function transportedClasses() {
      return this.ownTransports.map(function (transport) {
        return transport.class;
      }).reduce(function (array, subarray) {
        return array.concat(subarray);
      }, []);
      //.filter((string, index, array) => array.indexOf(string) === index)
    }
  },

  methods: {
    emitChange: function emitChange(newTransports, oldTransports) {
      if (this.multiple) {
        this.$emit('change', [].concat(toConsumableArray(newTransports)), [].concat(toConsumableArray(oldTransports)));
      } else {
        var newTransport = newTransports.length === 0 ? undefined : newTransports[0];
        var oldTransport = oldTransports.length === 0 ? undefined : oldTransports[0];
        this.$emit('change', _extends({}, newTransport), _extends({}, oldTransport));
      }
    },

    // can't be a computed prop because it has to "react" to $slot changes.
    children: function children() {
      return this.passengers.length !== 0 ? this.passengers : this.$slots.default || [];
    },
    noWrapper: function noWrapper() {
      var noWrapper = !this.hasAttributes && this.slim;
      if (noWrapper && this.children().length > 1) {
        console.warn('[portal-vue]: PortalTarget with `slim` option received more than one child element.');
      }
      return noWrapper;
    }
  },
  render: function render(h) {
    this.$options.abstract = true;
    var noWrapper = this.noWrapper();
    var children = this.children();
    var TransitionType = noWrapper ? 'transition' : 'transition-group';
    var Tag = this.tag;

    if (this.withTransition) {
      return h(
        TransitionType,
        babelHelperVueJsxMergeProps([this.transitionData, { 'class': 'vue-portal-target' }]),
        [children]
      );
    }

    return noWrapper ? children[0] : h(
      Tag,
      babelHelperVueJsxMergeProps([{
        'class': 'vue-portal-target ' + this.transportedClasses.join(' ')
      }, this.attributes]),
      [children]
    );
  }
};

var inBrowser = typeof window !== 'undefined';

var pid = 1;

var Portal = {
  abstract: false,
  name: 'portal',
  props: {
    /* global HTMLElement */
    disabled: { type: Boolean, default: false },
    name: { type: String, default: function _default() {
        return String(pid++);
      } },
    order: { type: Number, default: 0 },
    slim: { type: Boolean, default: false },
    slotProps: { type: Object, default: function _default() {
        return {};
      } },
    tag: { type: [String], default: 'DIV' },
    targetEl: { type: inBrowser ? [String, HTMLElement] : String },
    targetClass: { type: String },
    to: {
      type: String,
      default: function _default() {
        return String(Math.round(Math.random() * 10000000));
      }
    }
  },

  mounted: function mounted() {
    if (this.targetEl) {
      this.mountToTarget();
    }
    if (!this.disabled) {
      this.sendUpdate();
    }
    // Reset hack to make child components skip the portal when defining their $parent
    // was set to true during render when we render something locally.
    if (this.$options.abstract) {
      this.$options.abstract = false;
    }
  },
  updated: function updated() {
    if (this.disabled) {
      this.clear();
    } else {
      this.sendUpdate();
    }
    // Reset hack to make child components skip the portal when defining their $parent
    // was set to true during render when we render something locally.
    if (this.$options.abstract) {
      this.$options.abstract = false;
    }
  },
  beforeDestroy: function beforeDestroy() {
    this.clear();
    if (this.mountedComp) {
      this.mountedComp.$destroy();
    }
  },

  watch: {
    to: function to(newValue, oldValue) {
      oldValue && oldValue !== newValue && this.clear(oldValue);
      this.sendUpdate();
    },
    targetEl: function targetEl(newValue, oldValue) {
      if (newValue) {
        this.mountToTarget();
      }
    }
  },

  methods: {
    normalizedSlots: function normalizedSlots() {
      return this.$scopedSlots.default ? [this.$scopedSlots.default] : this.$slots.default;
    },
    sendUpdate: function sendUpdate() {
      var slotContent = this.normalizedSlots();

      if (slotContent) {
        wormhole.open({
          from: this.name,
          to: this.to,
          passengers: [].concat(toConsumableArray(slotContent)),
          class: this.targetClass && this.targetClass.split(' '),
          order: this.order
        });
      } else {
        this.clear();
      }
    },
    clear: function clear(target) {
      wormhole.close({
        from: this.name,
        to: target || this.to
      });
    },
    mountToTarget: function mountToTarget() {
      var el = void 0;
      var target = this.targetEl;

      if (typeof target === 'string') {
        el = document.querySelector(target);
      } else if (target instanceof HTMLElement) {
        el = target;
      } else {
        console.warn('[vue-portal]: value of targetEl must be of type String or HTMLElement');
        return;
      }

      if (el) {
        var newTarget = new Vue(_extends({}, PortalTarget, {
          parent: this,
          propsData: {
            name: this.to,
            tag: el.tagName,
            attributes: extractAttributes(el)
          }
        }));
        newTarget.$mount(el);
        this.mountedComp = newTarget;
      } else {
        console.warn('[vue-portal]: The specified targetEl ' + target + ' was not found');
      }
    },
    normalizeChildren: function normalizeChildren(children) {
      return typeof children === 'function' ? children(this.slotProps) : children;
    }
  },

  render: function render(h) {
    var children = this.$slots.default || this.$scopedSlots.default || [];
    var Tag = this.tag;
    if (children.length && this.disabled) {
      // hack to make child components skip the portal when defining their $parent
      this.$options.abstract = true;
      return children.length <= 1 && this.slim ? children[0] : h(Tag, [this.normalizeChildren(children)]);
    } else {
      return h(Tag, {
        'class': 'v-portal',
        style: 'display: none',
        key: 'v-portal-placeholder'
      });
      // h(this.tag, { class: { 'v-portal': true }, style: { display: 'none' }, key: 'v-portal-placeholder' })
    }
  }
};

function install(Vue$$1) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  Vue$$1.component(opts.portalName || 'Portal', Portal);
  Vue$$1.component(opts.portalTargetName || 'PortalTarget', PortalTarget);
}
if (typeof window !== 'undefined' && window.Vue) {
  window.Vue.use({ install: install });
}

var index = {
  install: install,
  Portal: Portal,
  PortalTarget: PortalTarget,
  Wormhole: wormhole
};

return index;

})));
//# sourceMappingURL=portal-vue.js.map
