<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BackgroundImageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'bg_image'    => 'required|mimes:jpg,jpeg,png',
        ];
    }

    public function messages()
    {
        return[
            'bg_image.required'   => 'Image is required',
            'bg_image.mimes'      => 'Choose jpg,jpeg,png file',
              
        ];
    }
}
