<?php
namespace App\Events\Chat;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class ChatJoinNotification  implements ShouldBroadcast 
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    /**
     * Create a new event instance.
     *
     * @return void
     */
     protected $user_name;
      public function __construct($user_name)
    {
        $this->user_name=$user_name;
        //dd($this->user_name);
    }
    /**
     * Get the channels the event should broadcast on.
     *
     * @return Channel|array
     */
    public function broadcastOn()
    {
     return new channel('notification');
    }
    public function broadcastWith()
   { 
             return ['user_name'=>$this->user_name];
  }
}